# Контроллер TA4 ICTA

Контроллер ICTA (ICTA означает «If Condition Then Action») используется для мониторинга и управления машинами. Контроллер может использоваться для считывания данных с машин и других блоков и, в зависимости от этого, включения/выключения других машин и блоков.

### 8 правил контроллера

Контроллер работает на основе правил, при этом для одного контроллера можно создать до 8 правил.

Примеры правил:

- Если распределитель заблокирован, то толкатель перед ним следует отключить.
- Если машина отображает состояние неисправности, должна быть включена лампа, указывающая на неисправность.
- Если игрок находится близко к детектору игроков, его имя должно отображаться на дисплее.
- Если датчик тележки распознает тележку, тележку следует загрузить (толкатель включить)

Все правила должны выполняться только так часто, как это необходимо. Это имеет два преимущества:

- батарея контроллера служит дольше (для каждого контроллера нужна своя батарея)
- нагрузка на сервер ниже (следовательно меньше лагов)

### Циклическое выполнение правил

Эти правила циклически проверяются контроллером. Если условие выполнено, действие выполняется. Пока условие не выполнено, ничего не происходит. Даже если условие уже было выполнено, когда правило было отредактировано в последний раз и действие было выполнено, ничего не происходит. Условие должно сначала стать недействительным, а затем снова применяться, чтобы действие было выполнено снова.

Частота проверки правила контроллером может быть настроена индивидуально для каждого правила. Для каждого правила (1..1000) необходимо указать время цикла в секундах (`Цикл/с`).

### Событийно-управляемое выполнение правил

В качестве альтернативы циклически проверяемым правилам существует также событийно-управляемое выполнение правил.

События — это команды, которые отправляются из других блоков в контроллер. Примерами являются датчики и переключатели. Они отправляют команды `on` / `off`. Например, если переключатель включен, он отправляет команду `on`, если он выключен, он отправляет команду `off` в блок с номером, который был настроен для переключателя.

Для правил, которые должны выполняться в режиме управления событиями, необходимо указать время цикла 0.

### Время задержки

Вам необходимо установить время задержки (`after/s`) для каждого действия. Если действие должно быть выполнено немедленно, необходимо ввести 0.

#### Условия/Положения

Для каждого правила можно настроить одно из следующих условий. Однако для каждого правила можно настроить только одно условие.

- `initial` - Это условие всегда выполняется после включения контроллера и используется, например, для выключения лампы, чтобы ее можно было снова включить в случае возникновения ошибки.

- `true` - Это условие всегда выполняется и используется, например, для того, чтобы заставить лампу мигать. Для этого требуются два правила. Например, если оба правила имеют время цикла 2 с, но первое правило имеет время задержки 0 с, а второе правило имеет время задержки 1 с, то лампа может циклически включаться и выключаться снова.

- `condition` - В зависимости от другого правила, здесь может быть запущено действие. Для этого необходимо указать номер другого правила (1..8). Это означает, что с одним `condition` можно выполнить 2 действия. С дополнительным настраиваемым условием `was not true` использовалось для выключения лампы, например, когда условие больше не выполняется.

- `inputs` - Это позволяет оценить полученное значение `on` / `off` команды (события). Обратите внимание: для правил, которые должны выполняться под управлением событий, необходимо указать время цикла 0.

- `read block state` - Это позволяет запросить состояние машины. Необходимо ввести номер машины (номер блока). Возможные состояния машины:

- `running` -> машина работает
- `остановлен` -> машина выключена
- `standby` -> машина не занята, например, потому что инвентарь пуст
- `заблокировано` -> машина не может ничего сделать, например, начальный инвентарь заполнен
- `fault` -> машина имеет неисправность. Меню машины может предоставить дополнительную информацию
- `unloaded` -> Машины на большем расстоянии могли быть выгружены с сервера без блока forceload. Тогда они не активны.

Если выполнено настроенное условие, например, «блок номер 456 остановлен», действие выполняется.

**Информация:** **Номер блока** — это уникальный номер, который генерируется Techage при размещении большого количества блоков Techage и отображается в виде информационного текста позади имени блока. Номер блока используется для адресации во время связи между контроллерами Techage и машинами.

Самый простой способ определить, какие машины предоставляют какую информацию о состоянии, — это использовать гаечный ключ / инструмент Techage Info непосредственно на машине.

- `считывание количества топлива` - это может быть использовано для считывания количества топлива, оставшегося в машине (обычно от 0 до 99 единиц), и для сравнения его со значением «больше» или «меньше». Если настроенное условие выполнено, действие выполняется.
`считывание мощности / нагрузки жидкости` - Это означает, что заряд батареи или устройства хранения тепла может быть запрошен в процентах (значения от 0..100) и проверен на 'больше' / 'меньше' с настроенным условием. Если условие выполняется, действие выполняется.

- `read provided power` - Это можно использовать для запроса количества электроэнергии, которую поставляет генератор (в ku). Значение можно проверить с помощью настроенного условия для 'больше' / 'меньше'. Если условие выполняется, действие выполняется. Поскольку батареи не только излучают электричество, но и поглощают его, это значение отрицательно, когда батарея заряжена.

- `считывать состояние сундука` - Это позволяет запрашивать и оценивать состояние сундука TA3/TA4. Сундуки предоставляют состояния:

- `пустой` - сундук пуст
- `загружен` - сундук частично заполнен
- `full` - Все стопки в сундуке хотя бы частично заняты

Если условие выполнено, действие выполняется.

- `прочитать состояние сигнальной вышки` - позволяет запрашивать и проверять цвет сигнальной вышки. Сигнальные вышки передают значения `выкл`, `зеленый`, `янтарный`, `красный`. Если условие выполняется, действие выполняется.

- `read Player Detector` - Это можно использовать для запроса детектора игроков. Детектор предоставляет имя игрока рядом с детектором. Если на дисплее должно отображаться не только определенное, но и каждое имя игрока, введите '*' в 'имя(я) игрока(ов).
Вы также можете ввести несколько имен, разделенных пробелами. Если действие должно быть выполнено, когда рядом нет игрока, введите `-`.

### Действия

Для всех действий, которые управляют блоком (например, лампой), номер блока должен быть указан в действии. Только одно действие может быть настроено на одно правило.

- `печать в окно вывода` - например, текст может быть выведен в меню контроллера (в разделе 'outp') для целей тестирования. Это особенно полезно при устранении неполадок.
- `send Signal Tower command` - Позволяет задать цвет Signal Tower. Возможные значения: `off`,` green`, `amber`,` red`.
- «выключить/включить блок» - позволяет снова включить или выключить блок или машину.
- `Дисплей: перезаписать одну строку` - Позволяет выводить текст на дисплей. Необходимо указать номер строки на дисплее (1..5).
Если имя игрока детектора игроков должно быть выведено из условия, то «текст» включен
Введите символ `*`.
- `Дисплей: Очистить экран` - очистить экран
- «отправить сообщение в чате» - позволяет вам отправить себе сообщение в чате.
- `открыть / закрыть дверь` - Это позволяет открывать и закрывать стандартные двери. Поскольку двери не имеют номеров, необходимо ввести координаты двери. Координацию двери можно легко определить с помощью гаечного ключа / инструмента Techage Info.
- `Включить/выключить фильтр распределителя` - Позволяет включать и выключать фильтр/выходы распределителя. Соответствующий выход должен быть указан через цвет.

### Разнообразный

Контроллер имеет собственную справку и информацию по всем командам через меню контроллера.

Данные машины считываются, а блоки и машины управляются с помощью команд. Чтобы понять, как работают команды, полезна глава TA3 -> Логика / переключение блоков в справке по игре (план строительства).


