# Tech Age мод

Tech Age - это технологический мод с 5 стадиями развития:

TA1: Железный век
Используйте инструменты и приспособления, такие как угольные печи, гравийные сита, молоты и бункеры, чтобы добывать и обрабатывать необходимые руды и металлы.

TA2: Паровой век
Постройте паровой двигатель с механическим приводом и используйте его для работы своих первых машин по переработке руды.

TA3: Нефтяной век
Найдите и добывайте нефть, постройте железные дороги для транспортировки нефти. Электростанция дает необходимое электричество для ваших машин. Электрический свет освещает ваши промышленные предприятия.

TA4: Настоящее время
Возобновляемые источники энергии, такие как ветер, солнце и биотопливо, помогают вам покинуть нефтяной век. С помощью современных технологий и умных машин вы отправляетесь в будущее.

TA5: Будущее
Машины, преодолевающие пространство и время, новые источники энергии и другие достижения определяют вашу жизнь.


Примечание: Нажав на знак "плюс", вы попадаете в подразделы этого руководства.

[techage_ta4|image]



## Подсказки

Эта документация доступна как "в игре" (план строительства блоков), так и на GitHub в виде MD-файлов.

- Ссылка: https://github.com/joe7575/techage/wiki

Строительные планы (схемы) для постройки машин и картинки доступны только в игре.

В Tech Age вам придется начинать все сначала. Вы можете создавать блоки TA2 только с помощью предметов из TA1, для TA3 вам нужны результаты из TA2 и т.д.

В TA2 машины работают только с приводными осями.

В TA3 машины работают от электричества и имеют коммуникационный интерфейс для дистанционного управления.

TA4 добавляет больше источников энергии, но также и более сложные логистические задачи (линии электропередач, транспортировка изделий).



## Изменения по сравнению с версией 1.0

С версии 1.0 (07/17/2021) изменилось следующее:

- Изменился алгоритм расчета распределения энергии. Это делает системы хранения энергии более важными. Они компенсируют колебания, что важно для больших сетей с несколькими генераторами.
- По этой причине TA2 обзавелась собственным накопителем энергии.
- Аккумуляторные блоки из TA3 также служат в качестве накопителей энергии. Их функциональность была соответствующим образом адаптирована.
- Система хранения TA4 была пересмотрена. Теплообменник получил новый номер, поскольку его функциональность была перенесена с нижнего на средний блок. Если они управлялись дистанционно, номер узла должен быть адаптирован. Генераторы больше не имеют собственного меню, а включаются/выключаются только через теплообменник. Теплообменник и генератор теперь должны быть подключены к одной сети!
- Несколько электросетей теперь могут быть соединены через трансформаторные блоки TA4.
- Также появился блок счетчиков электроэнергии TA4 для подсетей.
- Как минимум один блок аккумуляторов или система хранения в каждой сети


### Советы по обновлению версии

Многие другие блоки получили незначительные изменения. Поэтому возможно, что машины или системы не будут запускаться сразу после обновлению версии. В случае неполадок помогут следующие советы:

- выключите и снова включите машины
- снимите блок силовых кабелей и установите его на место
- полностью снимите блок и установите его на место



## Руды и минералы

Techage добавляет в игру несколько новых предметов:

- Меридий - сплав для производства светящихся инструментов в TA1
- Усмий - руда, которая добывается в TA2 и необходима для TA3
- Бабориум - металл, необходимый для рецептов в TA3
- Нефть - необходима в TA3
- Боксит - алюминиевая руда, которая необходима в TA4 для производства алюминия
- Базальт - возникает при соприкосновении воды и лав


### Меридий

Меридий - это сплав стали и кристаллов мезекона. Слитки меридиума можно изготовить с помощью угольной горелки из стали и кристаллов мезекона. Меридий светится в темноте. Инструменты из меридиума также светятся и поэтому очень полезны при подземной добыче.

[meridium|image]


### Усмий

Усмий встречается только в виде самородков и может быть получен только при промывке гравия с помощью системы промывки гравия TA2/TA3.

[usmium|image]


### Баборий

Барборий можно получить только при подземной добыче. Это вещество можно найти только на глубине от -250 до -340 метров.

Бабориум можно переплавить только в промышленной печи TA3.


[baborium|image]


### Нефть

Нефть можно найти только с помощью Исследователя и добыть с помощью соответствующих машин TA3. См. TA3.

[oil|image]


### Боксит

Боксит можно добыть только в подземной шахте. Боксит можно найти только в камне на высоте от -50 до -500 метров.
Он необходим для производства алюминия, который в основном используется в TA4.

[bauxite|image]


### Базальт

Базальт образуется только при соединении лавы и воды.
Лучше всего создать систему, в которой лава и вода будут течь вместе.
Базальт образуется там, где встречаются обе жидкости.
Вы можете создать автоматический генератор базальта с помощью Sign Bot.

[basalt|image]


## История обновлений

- 28.09.2019: Solar system added
- 05.10.2019: Data on the solar system and description of the inverter and the power terminal changed
- 18.11.2019: Chapter for ores, reactor, aluminum, silo, bauxite, furnace heating, gravel washing system added
- 22.02.2020: corrections and chapters on the update
- 29.02.2020: ICTA controller added and further corrections
- 14.03.2020 Lua controller added and further corrections
- 22.03.2020 More TA4 blocks added
