
# TA4: Настоящее

Возобновляемые источники энергии, такие как ветер, солнце и биотопливо, помогут вам покинуть нефтяной век. С помощью современных технологий и умных машин вы отправляетесь в будущее.

[techage_ta4|image].


## Ветрогенератор

Ветрогенератор всегда дает электричество, когда есть ветер. В игре ветра нет, но мод симулирует это, включая ветряки только утром (5:00 - 9:00) и вечером (17:00 - 21:00). Ветрогенератор дает электричество только в том случае, если он установлен в подходящем месте.

Ветряные электростанции TA - это исключительно шельфовые установки, то есть они должны быть построены в море. Это означает, что ветряные турбины могут быть построены только в морском (океаническом) биоме и что вокруг мачты должно быть достаточно воды и хороший обзор.

Чтобы найти подходящее место, нажмите на воду с помощью гаечного ключа (TechAge Info Tool). В чате появится сообщение о том, подходит ли это место для мачты ветряка.

Ток должен быть проведен от блока ротора вниз через мачту. Сначала протяните силовой кабель вверх, а затем "заштукатурьте" его с помощью опорных блоков TA4. Внизу можно построить рабочую платформу. На плане справа показана конструкция в верхней части.

Ветрогенератор выдает 70 ku, но только 8 часов в день (см. выше).

[ta4_windturbine|plan]


### TA4 Ветрогенератор

Блок ветрогенератора (ротор) - это сердце ветрогенератора. Этот блок должен быть размещен на вершине мачты. В идеале при высоте над уровнем моря Y = 15, тогда вы останетесь в пределах блока карты / блока загрузки карты(forceload) размещенным на уровне моря.
При запуске турбины проверяются все условия для работы ветряка. Если все условия соблюдены, лопасти ротора (крылья) появляются автоматически. В противном случае вы получите сообщение об ошибке.

[ta4_windturbine|image]


### TA4 Гондола ветрогенератора

Этот блок должен быть расположен на черном конце блока ветрогенератора.

[ta4_nacelle|image]


### TA4 Сигнальная лампа ветрогенератора

Эта мигающая лампочка предназначена только для декоративных целей и может быть размещена на верхней части блока ветрогенератора.

[ta4_blinklamp|image]


### TA4 Мачта

Таким образом строится мачта для ветрогенератора. Однако эти блоки не устанавливаются вручную, а должны быть установлены с помощью шпателя, так что линия электропередачи к верхушке мачты заменяется этими блоками (см. раздел "TA Электрический кабель").

[ta4_pillar|image]


## Солнечная электростанция

Солнечная электростанция вырабатывает электричество только тогда, когда светит солнце. В игре это происходит каждый игровой день с 6:00 утра до 6:00 вечера.
В это время всегда доступна одинаковая мощность. После 18:00 солнечные модули полностью отключаются.

Температура в биоме имеет решающее значение для работы солнечных модулей. Чем жарче температура, тем эффективнее генерация электроэнергии.
Температуру биома можно определить с помощью Techage Info Tool (гаечный ключ). Обычно она колеблется между 0 и 100:

- полная мощность доступна при температуре 100 градусов
- при 50 градусах доступна половина мощности
- при 0 градусах солнечная электроэнергия недоступна

Поэтому для солнечной электростанции рекомендуется искать жаркие степи и пустыни.
Для передачи электроэнергии имеются воздушные линии.
Однако можно производить и водород, который можно транспортировать и превращать в электричество в месте назначения.

Самая маленькая единица в солнечной системе - это два солнечных модуля и один модуль-носитель. Несущий модуль должен быть размещен первым, а два солнечных модуля слева и справа от него (не выше!).

На плане справа показаны 3 блока, каждый с двумя солнечными модулями и одним несущим модулем, подключенные к инвертору с помощью красных кабелей.

Солнечные модули выдают постоянное напряжение, которое не может быть подано непосредственно в электросеть. Поэтому сначала солнечные модули необходимо подключить к инвертору через красный кабель. Модуль имеет два соединения, одно из которых предназначено для подключения красного кабеля к солнечным модулям (постоянный ток), а другое - для подключения серого кабеля к электросети (переменный ток).

Область карты, на которой расположена солнечная электростанция, должна быть полностью загружена. Это относится и к позиции над солнечным модулем, поскольку там регулярно измеряется сила света. Поэтому рекомендуется сначала установить блок загрузки карты (forceload), а затем разместить модули в этой области.

[ta4_solarplant|plan]


### TA4 Солнечный модуль

Солнечный модуль должен быть установлен на несущий модуль. Всегда требуется два солнечных модуля.
В паре солнечные модули вырабатывают до 3 ku электроэнергии, в зависимости от температуры на месте установки.
При использовании солнечных модулей необходимо следить за тем, чтобы они были полностью освещены дневным светом и не были затенены блоками или деревьями. Это можно проверить с помощью ТА гаечного ключа (Info Tool).

[ta4_solarmodule|image]


### TA4 Кронштейн для солнечных батарей

Кронштейн доступен в двух вариантах высоты (1 м и 2 м). Оба варианта функционально идентичны.
Кронштейны можно размещать непосредственно рядом друг с другом и таким образом соединять их в ряд. Подключение к инвертору или к другим сериям модулей должно осуществляться с помощью красных низковольтных кабелей или низковольтных соединителей.

[ta4_solarcarrier|image].


### TA4 Солнечный инвертор

Инвертор преобразует солнечную энергию постоянного тока в переменный ток, чтобы она могла быть подана в электросеть.
Инвертор может подавать максимум 100 ku электроэнергии, что соответствует 33 солнечным модулям или более.

[ta4_solar_inverter|image].


### TA4 Низковольтный кабель

Низковольтный кабель используется для подключения рядов солнечных модулей к инвертору. Кабель не должен использоваться для других целей.

Максимальная длина кабеля составляет 200 м.

[ta4_powercable|image].


### TA4 Низковольтный соединитель

Распределительная коробка должна быть установлена на полу. Она имеет только 4 соединения (в 4 направлениях).

[ta4_powerbox|image]


### TA4 Солнечный элемент для уличного фонаря

Как следует из названия, солнечная батарея для уличного фонаря используется для питания уличного фонаря. Один солнечный элемент может питать две лампы (1 кю). Солнечная батарея накапливает солнечную энергию в течение дня и подает электричество на лампу ночью. Это означает, что лампа светится только в темноте.

Этот солнечный элемент нельзя комбинировать с другими солнечными модулями.

[ta4_minicell|image].



## Тепловой накопитель энергии

Тепловой накопитель энергии заменяет батарейный блок из TA3.

Тепловой накопитель энергии состоит из бетонной оболочки (бетонных блоков), заполненной гравием. Возможны пять размеров накопителя:

- Крышка из бетонных блоков 5x5x5, заполненная гравием 27, вместимость: 22,5 kud
- Крышка из бетонных блоков 7x7x7, заполненная гравием 125, вместимость: 104 kud
- Крышка из бетонных блоков 9x9x9, заполнена гравием 343, вместимость: 286 kud
- Крышка из бетонных блоков 11x11x11, заполненная гравием 729, вместимость: 610 kud
- Крышка из бетонных блоков 13x13x13, заполненная гравием 1331, вместимость: 1112 kud

В бетонной оболочке может быть окно из обсидианового стеклоблока. Оно должно располагаться точно посередине стены. Через это окно можно увидеть, загружен ли накопитель более чем на 80 %. На плане справа показана структура TA4 теплообменника, состоящего из 3 блоков, TA4 турбины и TA4 генератора. Обратите внимание на выравнивание теплообменника (стрелка на блоке 1 должна указывать на турбину).

В отличие от плана справа, соединения на блоке хранения должны находиться на одном уровне (располагаться горизонтально, т.е. не снизу и не сверху). TA4 Вводы труб должны находиться точно посередине стены и быть обращены друг к другу. Желтые TA3 трубы используются в качестве паровых труб. Паровые трубы TA2 здесь использовать нельзя.
Как генератор, так и теплообменник имеют силовой разъем и должны быть подключены к электросети.

В принципе, тепловой накопитель энергии работает точно так же, как и TA3 аккумуляторы, только с гораздо большей емкостью.

Для того чтобы система хранения тепла работала, все блоки (также бетонная оболочка и гравий) должны быть загружены с помощью блока загрузки карты (forceload).

[ta4_storagesystem|plan]


### TA4 Теплообменник

Теплообменник состоит из 3 частей, которые нужно поставить друг на друга, причем стрелка первого блока должна быть направлена в сторону турбины. Соединение турбины и теплообменника должно производиться TA3 жёлтыми трубами.
Теплообменник должен быть подключен к электросети. Накопитель энергии заряжается через теплообменник при условии наличия достаточного количества электроэнергии.

[ta4_heatexchanger|image]


### TA4 Турбина

Турбина является частью накопителя энергии. Она должна быть размещена рядом с генератором и соединена с теплообменником с помощью желтых труб TA4, как показано на плане.

[ta4_turbine|image]


### TA4 Генератор

Генератор является частью накопителя энергии. Он используется для выработки электроэнергии и таким образом высвобождает энергию из энергонакопителя. Поэтому генератор также должен быть подключен к электросети.

Внимание: и теплообменник, и генератор должны быть подключены к одной электросети!

[ta4_generator|image]


### TA4 Ввод трубы

По одному блоку ввода трубы должно быть установлено с обеих сторон блока хранения. Блоки должны располагаться точно напротив друг друга.

Блоки ввода труб **не могут** использоваться в качестве спрятанных труб в стене, вместо них используйте TA3 блоки ввода труб в стену.

[ta4_pipeinlet|image]


### TA3 Труба

TA3 Желтые трубы используются для передачи газа и жидкостей.
Максимальная длина трубопровода составляет 100м (блоков).

[ta4_pipe|image]



## Распределение питания

С помощью силовых кабелей и распределительных коробок можно создавать электрические сети до 1000 блоков/узлов. Однако следует отметить, что необходимо учитывать и распределительные коробки. Это означает, что к электросети можно подключить до 500 генераторов/накопителей/машин/ламп и т.п.

С помощью разделительного трансформатора и счетчика электроэнергии можно соединять сети, образуя еще более крупные структуры.

[ta4_transformer|image]

### TA4 Изолирующий трансформатор

С помощью разделительного трансформатора можно соединить две электросети в одну большую сеть. Разделительный трансформатор может передавать электроэнергию в обоих направлениях.

Разделительный трансформатор может передавать до 300 ku. Максимальное значение регулируется через меню гаечного ключа.

[ta4_transformer|image]

### TA4 Электрический счетчик

С помощью электросчетчика можно соединить две электрические сети в одну большую сеть. Электросчетчик передает электроэнергию только в одном направлении (обратите внимание на стрелку). Количество пропущенной через него электроэнергии (в kud) измеряется и отображается на дисплее. Это значение также может быть запрошено Lua контроллером с помощью команды `consumption`. Текущий ток можно узнать с помощью команды `current`.

Счетчик электроэнергии может пропускать до 200 ku. Максимальное значение настраивается через меню гаечного ключа.

Через меню гаечного ключа можно также ввести обратный отсчет мощности. Когда этот отсчет достигнет нуля, счетчик электроэнергии выключится. Обратный отсчет можно запросить с помощью команды `countdown`.

[ta4_electricmeter|image].

### TA4 Лазер

Лазер TA4 используется для беспроводной передачи энергии. Для этого необходимы два блока:  TA4 лазерный излучатель и TA4 приемник лазерного луча. Между двумя блоками должен быть воздушный зазор, чтобы лазерный луч мог распространяться от излучателя к приемнику. Сначала необходимо установить излучатель. Это сразу же включает лазерный луч и показывает возможные положения приемника. Возможные позиции приемника также отображаются в чате.

С помощью лазера можно преодолевать расстояния до 96 блоков. Как только соединение установлено (ток не протекает), об этом сообщается в информационном тексте излучателя и приемника.

Сами лазерные блоки не требуют электричества.

[ta4_laser|image]



## Водород

Электролиз можно использовать для разделения электричества на водород и кислород. С другой стороны, водород можно превратить обратно в электричество с помощью кислорода из воздуха, используя топливный элемент.
Это позволяет преобразовывать избыток электроэнергии в водород и хранить его.
В игре водород можно преобразовать обратно в электроэнергию с помощью топливного элемента.

Это означает, что электроэнергию (в виде водорода) можно не только хранить в резервуарах, но и транспортировать с помощью тележки-цистерны или труб.

Однако преобразование электричества в водород и обратно происходит с потерями. Из 100 единиц электроэнергии после преобразования в водород и обратно получится только 95 единиц.

[ta4_hydrogen|image].


### Электролизер

Электролизер преобразует электричество в водород.
Питание должно подключатся слева. Водород можно откачивать с помощью труб и насосов с правой стороны электролизера.

Электролизер может потреблять до 35 ku электроэнергии, а затем генерировать водород каждые 4 секунда.
В электролизер помещается 200 единиц водорода.

Электролизер имеет меню гаечного ключа для настройки потребляемого тока и точки отключения.

Если накопленная в электросети энергия падает ниже заданного значения точки отключения, электролизер автоматически отключается. Это предотвращает опустошение систем хранения.

[ta4_electrolyzer|image].


### Топливный элемент

Топливный элемент преобразует водород в электричество.
Водород в него должен подаваться слева с помощью насоса. Подключение питания находится справа.

Топливный элемент может производить до 34 ku электроэнергии и нуждается в порции водорода каждые 4 секунды.

Обычно топливный элемент работает как генератор категории 2 (как и другие аккумуляторные системы).
В этом случае нельзя заряжать другие блоки категории 2, например блок аккумуляторов. Однако топливный элемент можно также использовать в качестве генератора категории 1 с помощью переключателя.

[ta4_fuelcell|image]


## Химический реактор

Реактор используется для переработки нефтепродуктов, полученных из дистилляционной колонны или по другим рецептам, в новые вещества.
На плане слева показан только один из возможных вариантов, поскольку расположение бункеров и резервуаров зависит от рецепта.

Первичный продукт всегда выводится на боковую сторону реакторной стойки, независимо от того, является ли он порошком или жидкостью. Отходы (вторичный продукт) всегда выгружаются в нижней части реакторной стойки.

Реактор состоит из:
- Различные резервуары и бункеры с ингредиентами, которые подключаются к дозатору с помощью труб
- Опционально - основание реактора, которое выгружает отходы из реактора (необходимо только для рецептов с двумя выходными продуктами)
- Подставка для реактора, которая должна быть установлена на основание (если имеется). Подставка имеет подключение к электросети и потребляет 8 кю во время работы.
- Корпус реактора, который должен быть установлен на основание реактора
- Заливная труба, которая должна быть установлена на корпусе реактора
- Дозирующее устройство, которое должно быть подключено к резервуарам или бункерам и наливной трубе с помощью труб

Примечание 1: Жидкие вещества хранятся только в резервуарах, твердые вещества и вещества в виде порошка - только в бункерах. Это относится к ингредиентам и выходным продуктам.

Примечание 2: Резервуары или ьункеры с разным содержимым не должны быть соединены в систему трубопроводов. Напротив, несколько резервуаров или бункеров с одинаковым содержимым могут быть подвешены параллельно на одной линии.

При крекинге длинные цепочки углеводородов расщепляются на короткие с помощью катализатора.
Гиббситовый порошок служит катализатором (не расходуется). Его можно использовать для преобразования битума в мазут, мазута в нафту и нафты в бензин.

При гидрогенизации к молекуле добавляют пары атомов водорода, чтобы превратить короткоцепочечные углеводороды в длинноцепочечные.
Здесь железный порошок необходим в качестве катализатора (не расходуется). Его можно использовать для превращения газа (пропана) в изобутан,
изобутан в бензин, бензин в нафту, нафта в мазут, а мазут в битум.


[ta4_reactor|plan]


### TA4 Дозатор

Часть химического реактора.
Трубы для подачи исходных материалов могут быть подключены со всех 4 сторон дозатора. ингредиенты для реактора поступают вверх.

Рецепт можно задать и запустить реактор через дозатор.

Как и в случае с другими машинами:
- если дозатор находится в режиме ожидания, один или несколько ингредиентов отсутствуют
- если дозатор находится в заблокированном состоянии, выходной бак или бункер переполнен, неисправен или неправильно подключен

Дозатор не нуждается в электричестве. Рецепт обрабатывается каждые 10 с.

[ta4_doser|image]

### TA4 Химический реактор

Химический реактор. В реакторе имеется инвентарь для хранения катализаторов (для рецептов крекинга и гидрогенизации).

[ta4_reactor|image]


### TA4 Заливная труба

Часть химического реактора. Должна быть помещена на реактор. Если это не сработает, удалите трубу в вышеуказанном месте и поместите ее снова.

[ta4_fillerpipe|image]


### TA4 Подставка для реактора

Часть химического реактора. Здесь же находится подключение питания для реактора. Реактору требуется 8 ku электроэнергии.

Стойка имеет два патрубка: справа - для исходного продукта, внизу - для отходов, например, красного шлама при производстве алюминия.

[ta4_reactorstand|image].


### TA4 База реактора

Часть химического реактора. Необходим для слива отработанного продукта.

[ta4_reactorbase|image].


### TA4 Бункер

Часть химического реактора. Необходим для хранения веществ в виде порошка или гранул.

[ta4_silo|image]

## ICTA Контроллер

Контроллер ICTA
ICTA расшифровывается как Если Условие То Действие ("If Condition Then Action") используется для контроля и управления машинами. С помощью контроллера можно считывать данные с машин и других блоков и в зависимости от этого включать/выключать другие машины и блоки.

Данные машины считываются, блоки и машины управляются с помощью команд. Глава TA3 -> Логические/коммутационные блоки важна для понимания работы команд.

Для работы контроллера требуется батарея. Дисплей используется для вывода данных, сигнальная башня - для отображения ошибок.

[ta4_icta_controller|image]

### TA4 ICTA контроллер

Контроллер работает на основе правил `IF <условие> THEN <действие>`. Для одного контроллера можно создать до 8 правил.

Примерами правил являются:

- Если распределитель "заблокирован", толкатель перед ним должен быть выключен
- Если машина выдает ошибку, это должно отображаться на дисплее

Контроллер проверяет эти правила циклически. Для этого необходимо указать время цикла в секундах (``Цикл/сек'') для каждого правила (1..1000).

Для правил, оценивающих входной сигнал включения/выключения, например, от выключателя или детектора, необходимо указать время цикла 0. Значение 0 означает, что это правило должно выполняться всегда, когда входной сигнал изменился, например, кнопка передала новое значение.

Все правила должны выполняться только так часто, как это необходимо. Это имеет два преимущества:

- батарея контроллера служит дольше (для каждого контроллера нужна своя батарея)
- нагрузка на сервер ниже (следовательно, меньше задержек)

Для каждого действия необходимо задать время задержки (`после/с`). Если действие должно быть выполнено немедленно, необходимо ввести 0.

Контроллер имеет собственную справку и информацию по всем командам через меню контроллера.

[ta4_icta_controller|image]

### Батарея

Батарея должна располагаться в непосредственной близости от контроллера, т.е. в одном из 26 положений вокруг контроллера.

[ta4_battery|image]

### TA4 Дисплей

После установки дисплей показывает свой номер. По этому номеру к дисплею можно обращаться. На дисплей можно выводить тексты, при этом дисплей может отображать 5 строк и, соответственно, 5 различных текстов.

Строки текста всегда выравниваются по левому краю. Если текст должен быть выровнен по горизонтали, перед ним должен стоять символ "\t" (табулятор).

Дисплей обновляется не чаще одного раза в секунду.

[ta4_display|image]

### TA4 Дисплей XL

Дисплей TA4 Дисплей XL в два раза больше TA4 дисплея.

Строки текста всегда выравниваются по левому краю. Если текст должен быть выровнен по горизонтали, перед ним должен стоять символ "\t" (табулятор).

Дисплей обновляется не чаще, чем раз в две секунды.

[ta4_displayXL|image]


### TA4 Сигнальная башня

Сигнальная башня может отображать красный, зеленый и оранжевый цвета. Комбинация этих трех цветов невозможна.

[ta4_signaltower|image]



## TA4 Lua контроллер

Как следует из названия, контроллер Lua должен быть запрограммирован на языке программирования Lua. Руководство на английском языке доступно здесь:

https://github.com/joe7575/techage/blob/master/manuals/ta4_lua_controller_EN.md

Контроллеру Lua также требуется батарея. Батарея должна располагаться в непосредственной близости от контроллера, то есть в одном из 26 положений вокруг контроллера.

[ta4_lua_controller|image]

### TA4 Lua сервер

Сервер используется для централизованного хранения данных нескольких контроллеров Lua. Он также сохраняет данные после перезапуска сервера.

[ta4_lua_server|image]

### TA4 Блок датчиков / сундук

Блок датчиков TA4 используется для организации автоматических складов или торговых автоматов в сочетании с контроллером Lua.
Если что-то положить в ящик или убрать, или нажать одну из клавиш "F1" / "F2", на контроллер Lua будет отправлен сигнал о событии.
Блок датчиков поддерживает следующие команды:

- Статус ящика можно запросить через `state = $send_cmnd(<num>, "state")`. Возможные ответы: "empty", "loaded", "full".
- Последнее действие игрока можно запросить через `name, action = $send_cmnd(<num>, "action")`. `name` - это имя игрока. В качестве `action` возвращается одно из следующих действий: "put", "take", "f1", "f2".
- Содержимое ящика можно считать с помощью команды `stacks = $send_cmnd(<num>, "stacks")`. См.: https://github.com/joe7575/techage/blob/master/manuals/ta4_lua_controller_EN.md#sensor-chest
- Через `$send_cmnd(<num>, "text", "нажмите обе кнопки и\n положите что-нибудь в сундук")` текст может быть установлен в меню сенсорного блока.

Флажок "Разрешить публичный доступ к сундуку" позволяет установить, может ли ящик использоваться всеми или только игроками, имеющими здесь права доступа/защиты.

[ta4_sensor_chest|image]

### TA4 Терминал Lua контроллера

Терминал используется для ввода/вывода данных для контроллера Lua.

[ta4_terminal|image]



## TA4 Логические/коммутационные модули

### TA4 Кнопка/переключатель

Изменился только внешний вид кнопки/переключателя TA4. Функциональность такая же, как у кнопки/переключателя TA3. Однако, позже с помощью меню гаечного ключа данные можно изменить.

[ta4_button|image]

### TA4 2x Кнопка

Этот блок имеет две кнопки, которые могут быть индивидуально настроены с помощью меню гаечного ключа. Для каждой кнопки можно настроить маркировку и адрес целевого блока. Кроме того, для каждой кнопки можно настроить отправляемую команду.

[ta4_button_2x|image]


### TA4 4x Кнопка

Этот блок имеет четыре кнопки, которые могут быть индивидуально настроены с помощью меню гаечного ключа. Для каждой кнопки можно настроить маркировку и адрес целевого блока. Кроме того, для каждой кнопки можно настроить отправляемую команду.

[ta4_button_4x|image]

### TA4 2x Сигнальная лампа

Этот блок имеет две лампы, которыми можно управлять по отдельности. Каждая лампа может отображать цвета "красный", "зеленый" и "янтарный". Маркировка обеих ламп может быть настроена через меню гаечного ключа. Управление лампами осуществляется с помощью следующих команд:

- Переключите лампу 1 на красный цвет: `$send_cmnd(1234, "red", 1)`.
- Переключите лампу 2 на зеленый цвет: `$send_cmnd(1234, "green ", 2)`.
- Переключите лампу 1 на оранжевый цвет: `$send_cmnd(1234, "amber", 1)`.
- Выключите лампу 2: `$send_cmnd(1234, "off", 2)`.

[ta4_signallamp_2x|image]

### TA4 4x Сигнальная лампа

Этот блок имеет четыре лампы, которыми можно управлять по отдельности. Каждая лампа может отображать цвета "красный", "зеленый" и "янтарный". Маркировка всех ламп может быть настроена через меню гаечного ключа. Управление лампами осуществляется с помощью следующих команд:

- Переключите лампу 1 на красный цвет: `$send_cmnd(1234, "red", 1)`.
- Переключите лампу 2 на зеленый цвет: `$send_cmnd(1234, "green ", 2)`.
- Переключите лампу 3 на оранжевый цвет: `$send_cmnd(1234, "amber", 3)`.
- Выключите лампу 4: `$send_cmnd(1234, "off", 4)`

[ta4_signallamp_4x|image]

### TA4 Детектор игроков

Изменился только внешний вид детектора игроков TA4. Функциональность осталась такой же, как и у детектора игроков TA3.

[ta4_playerdetector|image]

### TA4 Сборщик состояний

[ta4_collector|image]

Сборщик состояний поочередно запрашивает состояние всех сконфигурированных машин. Если одна из машин достигла или превысила предварительно настроенный статус, отправляется команда "включить". Например, многие машины можно легко отслеживать на предмет неисправностей с помощью контроллера Lua.

### TA4 Детектор предметов

Функциональность такая же, как и у детектора предметов TA3. Кроме того, детектор подсчитывает переданные предметы.
Этот счетчик можно запросить командой 'count' и сбросить командой 'reset'.

[ta4_detector|image]

### TA4 Детектор блоков

Функциональность такая же, как и у детектора узлов TA3.

В отличие от детектора блоков TA3, здесь контролируемые позиции можно настраивать индивидуально. Для этого необходимо нажать кнопку "Запись". Затем необходимо щелкнуть по всем блокам, положение которых необходимо проверить. Затем необходимо нажать кнопку "Готово".

Можно выбрать до 4 блоков.

[ta4_nodedetector|image]

### TA4 Детектор заряда накопителей энергии

Детектор заряда измеряет состояние заряда накопителей энергии электросети каждые 8 с.

Если значение падает ниже настраиваемого порога (точки переключения), отправляется команда (по умолчанию: "off"). Если значение снова поднимается выше этой точки переключения, отправляется вторая команда (по умолчанию: "on"). Это позволяет отключать потребителей от сети, когда уровень заряда накопителя энергии падает ниже заданной точки переключения.

Для этого детектор заряда должен быть подключен к сети через распределительную коробку. Детектор заряда настраивается через меню гаечного ключа.

[ta4_chargedetector|image].

### TA4 Датчик взгляда

Датчик взгляда TA4 генерирует команду, когда на блок смотрит владелец или другие настроенные игроки, и посылает вторую команду, когда на блок больше не смотрят. Таким образом, он служит заменой кнопок/выключателей, например, для открытия/закрытия дверей.

Датчик взгляда TA4 можно запрограммировать только с помощью меню гаечного ключа. Если у вас в руках гаечный ключ, датчик не сработает, даже если на него смотрят.

[ta4_gaze_sensor|image]

### TA4 Секвенсор

С помощью секвенсора TA4 можно программировать целые процессы. Вот пример:

```
-- this is a comment
[1] send 1234 a2b
[30] send 1234 b2a
[60] goto 1
```


- Каждая строка начинается с числа, которое соответствует моменту времени `[<num>]`.
- Для времени допускаются значения от 1 до 50000
- 1 соответствует 100 мс, 50000 - около 4 игровых дней
- Допускаются пустые строки или комментарии (`-- comment`).
- С помощью команды `send <num> <command> <data>` вы можете отправить команду блоку
- С помощью `goto <num>` вы можете перейти на другую строку / точку во времени
- С помощью `stop` вы можете остановить секвенсор с задержкой, чтобы он не получил новую команду
  от кнопки или другого блока (для завершения движения)
  Без `stop` секвенсор переходит в режим остановки сразу после выполнения последней команды.

Секвенсор TA4 поддерживает следующие команды techage:

- `goto <num>` Переход к командной строке и запуск секвенсора
- `stop` Остановить секвенсор
- `on` и `off` как псевдонимы для `goto 1` и `stop`.

Команда `goto` принимается только тогда, когда секвенсор остановлен.

Время цикла (по умолчанию: 100 мс) может быть изменено для секвенсора через меню гаечного ключа.

[ta4_sequencer|image]



## Контроллеры перемещения/поворота

### TA4 Контроллер перемещения

Контроллер перемещения TA4 аналогичен "Контроллеру Дверей 2", но выбранные блоки не удаляются, а перемещаются.
Поскольку движущиеся блоки могут забирать с собой игроков и мобов, стоящих на блоке, с их помощью можно строить лифты и подобные транспортные системы.

Инструкции:

- Настройте контроллер и обучите перемещаемые блоки с помощью меню (можно обучить до 16 блоков)
- маршрут полета" должен быть введен с помощью спецификации x, y, z (относительно) (максимальное расстояние - 1000 м)
- Движение можно проверить с помощью кнопок меню "Move A-B" и "Move B-A".
- Вы также можете пролетать сквозь стены или другие блоки
- Целевая позиция блоков также может быть занята. В этом случае блоки сохраняются "невидимо". Это предназначено для раздвижных дверей и т. п.

Контроллер Move поддерживает следующие команды techage:

- `a2b` Переместите блок из A в B.
- `b2a` Переместите блок из B в A.
- `move` Переместить блок на другую сторону

Переключиться в режим работы `move xyz` можно через меню гаечного ключа. После переключения поддерживаются следующие команды techage:

- `move2` С помощью этой команды маршрут полета также должен быть задан в виде вектора x,y,z.
  Пример Lua-контроллера: `$send_cmnd(MOVE_CTLR, "move2", "0,12,0")`.
- `moveto` Перемещает блок в заданную позицию назначения (позиция назначения действительна для первого отмеченного блока, остальные блоки перемещаются относительно этой позиции)
- `reset` перемещает блок(ы) обратно в исходное положение

**Важные указания:**

- Если необходимо переместить несколько блоков, то при обучении нужно сначала нажать на блок, в котором будут находиться игроки/мобы.
- Если используется команда `moveto`, указанная целевая позиция применяется к блоку, который первым нажимается во время обучения.
- Если блок, который должен забрать игрока/моба, имеет уменьшенную высоту, ее необходимо установить в контроллере с помощью меню гаечного ключа (например, height = 0.5). В противном случае игрок/моб не будет "найден" и не будет забран.

[ta4_movecontroller|image]

### TA4 Контроллер поворота

Контроллер поворота TA4 похож на "Контроллер перемещения", но выбранные блоки не перемещаются, а поворачиваются вокруг своего центра вправо или влево.

Инструкции:

- Настройте контроллер и обучите перемещаемые блоки с помощью меню (можно обучить до 16 блоков)
- Движение можно проверить с помощью кнопок меню "Поворот налево" и "Поворот направо".

Контроллер поворота поддерживает следующие команды techage:

- `left` Повернуть налево
- `right` Повернуть направо
- `uturn` Развернуть на 180 градусов

[ta4_turncontroller|image]




## TA4 Лампы

TA4 содержит серию мощных ламп, которые позволяют улучшить освещение или справиться с особыми задачами.

### TA4 Фитолампа

Светодиодная лампа TA4 обеспечивает быстрый и энергичный рост всех растений, содержащихся в моде `farming`. Лампа освещает поле 3x3, поэтому растения можно выращивать и под землей.
Лампа должна быть установлена на один блок над землей в центре поля 3x3.

Лампу также можно использовать для выращивания цветов. Если поместить лампу над клумбой 3x3 из садовой почвы (Garden Soil) (Мод `compost`), цветы будут расти автоматически (над и под землей).

Вы можете собирать цветы с помощью бота Signs Bot, который также имеет соответствующий знак, который нужно разместить перед цветочным полем.

Лампа потребляет 1 кю электроэнергии.

[ta4_growlight|image]

### TA4 Уличный фонарь

Уличный светодиодный светильник TA4 - это светильник с особенно сильным освещением. Светильник состоит из корпуса, кронштейна и блоков для столбов.

Ток должен быть подведен снизу через мачту к корпусу лампы. Сначала протяните силовой кабель вверх, а затем "заштукатурьте" его с помощью блоков мачт для ламп.

Лампа потребляет 1 ku электроэнергии.

[ta4_streetlamp|image]

### TA4 Светодиодная промышленная лампа

Светодиодная промышленная лампа TA4 - это лампа с особенно сильным освещением. Питание лампы должно осуществляться сверху.

Лампа потребляет 1 ku электроэнергии.

[ta4_industriallamp|image]

### TA4 Cветофор

Светофор TA4 может быть в двух вариантах: черном (европейская версия) и желтом (американская версия). Кроме того, в комплект входят мачта, кронштейн и соединительный блок. Светофор может быть установлен на мачте. Однако он не может быть установлен на кронштейне. Это обусловлено техническими причинами. Поэтому существует соединительный блок, который помещается между кронштейном и светофором.

Светофором можно управлять с помощью команд, аналогичных командам TA4 сигнальной башни. Если также используется TA4 детектор игроков, светофор может реагировать на пешеходов или транспортные средства.

Светофор не требует электричества.

[ta4_trafficlight|image]


## TA4 Жидкостный фильтр

Жидкостный фильтр отфильтровывает красный шлам.
Часть красного шлама превращается в щелочь, которую можно собрать на дне в резервуар.
Другая часть становится пустынным булыжником и засоряет фильтрующий материал.
Если фильтр сильно засорился, его необходимо очистить и заново наполнить.
Фильтр состоит из базового слоя, 7 одинаковых фильтрующих слоев и верхнего слоя наполнителя.

[ta4_liquid_filter|image]

### Базовый слой

Вы можете увидеть структуру этого слоя на плане.

Щелочь собирается в резервуаре.

[ta4_liquid_filter_base|plan]

### Слой гравия

Этот слой должен быть заполнен гравием, как показано на плане.
Всего должно быть семь слоев гравия.
Со временем фильтр засоряется, и его приходится чистить и наполнять заново.

[ta4_liquid_filter_gravel|plan]

### Слой наполнения

Этот слой используется для наполнения фильтра красным шламом.
Красный шлам должен быть закачан в наливную трубу.

[ta4_liquid_filter_top|plan]




## TA4 Коллайдер (ускоритель частиц)

Коллайдер - это исследовательский центр, в котором проводятся фундаментальные исследования. Здесь можно получить очки опыта, которые требуются для TA5 (Future Age).

Как и его оригинал в ЦЕРНе в Женеве, коллайдер должен быть построен под землей. Стандартная глубина здесь - Y <= -28. Однако это значение может быть изменено персоналом сервера через конфигурацию. Вы можете спросить у других игроков в чате или воспользоваться блоком "TA4 Построитель детектора коллайдера".

На одного игрока может приходиться только один коллайдер. Поэтому нет смысла устанавливать два или более коллайдеров. Очки опыта начисляются игроку, владеющему коллайдером. Очки опыта не могут быть переданы.

Коллайдер состоит из "кольца", состоящего из трубок и магнитов, а также детектора с системой охлаждения.

- Детектор - это сердце системы. Именно здесь проводятся научные эксперименты. Детектор имеет размер 3x3x7 блоков.
- 22 магнита коллайдера TA4 (не магниты детектора коллайдера TA4!) должны быть соединены друг с другом через 5 блоков вакуумной трубы TA4. Каждый магнит также нуждается в электричестве и газовом соединении для охлаждения. Все это образует (как показано на плане справа) квадрат с длиной стороны 37 метров (блоков).

На плане объект показан сверху:

- серый блок - это детектор с рабочим блоком в центре
- красные блоки - магниты, синие - вакуумные трубы

[techage_collider_plan|plan]

### Детектор коллайдера

Установка детектора происходит автоматически с помощью блока "TA4 Построитель детектора коллайдера" (аналогично буровой вышке). Все необходимые для этого материалы должны быть сначала помещены в блок построителя. На блоке построителя схематически изображен детектор. Детектор строится над блоком построителя.

Детектор также можно снова разобрать с помощью построителя детектора.

Разъемы для подключения электричества, газа и вакуумных труб расположены на двух передних сторонах детектора. Сверху должен быть подключен насос TA4 одной всасывающей стороной для создания вакуума.

Система охлаждения должна быть подключена к задней части детектора. Система охлаждения показана на плане справа. В дополнение к теплообменнику TA4 блока хранилища энергии (который используется здесь для охлаждения) необходим блок охладителя TA4.

Примечание: Стрелка на теплообменнике должна быть направлена в противоположную сторону от детектора. К теплообменнику также должно быть подведено электричество.

[ta4_cooler|plan]


- Кроме того, требуется охлаждение, которое также должно быть установлено на детекторе. Для охлаждения требуется изобутан.
- Система требует довольно много электроэнергии и требует подключения к электросети.

### TA4 Терминал управления

Коллайдер управляется через TA4 терминал управления (не через терминал TA4 Lua-контроллера).

Этот терминал должен быть подключена к детектору коллайдера. Номер детектора отображается в виде информационного текста на блоке построителя коллайдера.

Терминал поддерживает следующие команды:

- `connect <номер>` (подключение к детектору)
- `start` (запуск детектора)
- `stop` (остановить детектор)
- `test <номер>` (проверка магнита)
- `points` (запрос уже полученных очков опыта)

Если во время `start` на магните произошла ошибка, выводится номер магнита. Команда `test` может быть использована для запроса дополнительной информации об ошибке магнита.

[ta4_terminal|image]

### Охлаждение и питание

Каждый магнит коллайдера TA4 также должен быть снабжен электричеством (как показано справа на плане) и изобутаном для охлаждения:

- Разъем для подключения питания находится на верхней части магнита.
- Соединение для охлаждения находится на передней панели магнита.
- Для охлаждения всей системы также требуется насос TA4 и резервуар TA4 с не менее чем 250 единицами изобутана.
- Система также требует много электроэнергии. Потребляемая мощность коллайдера равна 145 ku.

[techage_collider_plan2|plan]

### Строительство

При настройке коллайдера рекомендуется соблюдать следующую последовательность действий:

- Установите блок принудительной загрузки карты (forceload). Детектор с системой охлаждения должен полностью находиться в зоне блока принудительной загрузки карты (forceload).
- Установите блок построителя детектора коллайдера, заполните его необходимыми предметами и настройте детектор через меню
- Соберите кольцо из труб и магнитов
- Подключите все магниты и детектор с помощью кабелей питания
- Соедините все магниты и детектор с желтыми трубами и закачайте изобутан в систему труб с помощью насоса
- Установите насос TA4 в качестве вакуумного насоса на детектор и включите его (дополнительный резервуар не требуется). Если насос переходит в режим "ожидания", значит, вакуум создан. Это займет некоторое время.
- Соберите охладитель (теплообменник) и подключите его к кабелю питания
- Расположите "TA4 Терминал управления" перед детектором и подключите его к детектору через команду `connect <number>`.
- Включите/подключите источник питания
- Включите охладитель (теплообменник)
- Включите детектор с помощью `start` на TA4 терминале. После нескольких тестовых шагов детектор перейдет в нормальный режим работы или выдаст ошибку.
- Коллайдер должен работать непрерывно, а затем постепенно приносить очки опыта. Чтобы получить 10 очков, коллайдер должен работать несколько часов.

[techage_ta4c|image].




## Больше блоков TA4

### TA4 Блок рецептов

В блоке рецептов можно сохранить до 10 рецептов. Затем эти рецепты можно вызвать с помощью команды TA4 Autocrafter. Это позволяет настроить рецепт автокрафтера с помощью команды. Рецепты в блоке рецептов также могут быть запрошены напрямую с помощью команды.

`input <index>` считывает рецепт из блока рецептов TA4. `<index>` - это номер рецепта. Блок возвращает список ингредиентов рецепта.

Пример: `$send_cmnd(1234, "input", 1)`.

[ta4_recipeblock|image]

### TA4 Автокрафтер

Функционал соответствует TA3 Автокрафтеру.

Мощность обработки составляет 4 предмета каждые 4 с. Для этого автокрафтеру требуется 9 ku электроэнергии.

Кроме того, автокрафтер TA4 поддерживает выбор различных рецептов с помощью следующих команд:

`recipe "<number>.<index>"` переключает автокрафтер на рецепт из блока рецептов TA4. `<number>` - номер блока рецептов, `<index>` - номер рецепта. Пример: `$send_cmnd(1234, "recipe", "5467.1")`.

Кроме того, рецепт можно выбрать через список ингредиентов, например:
`$send_cmnd(1234, "recipe", "default:coal_lump,,,default:stick")`
Здесь должны быть указаны все технические имена рецепта, разделенные запятыми. См. также команду `input` в блоке рецептов TA4.

Команда `flush` перемещает все предметы из входного инвентаря в выходной инвентарь. Команда возвращает `true`, если входной инвентарь был полностью опустошен. Если возвращается `false` (выходной инвентарь заполнен), команду нужно повторить позже.

[ta4_autocrafter|image]

### TA4 Резервуар

См. TA3 Резервуар.

TA4 Резервуар вмещает 2000 единиц или 200 бочек жидкости.

[ta4_tank|image]

### TA4 Насос

См. TA3 Насос.

Насос TA4 перекачивает 8 единиц жидкости каждые две секунды.

В режиме "Ограничитель расхода" можно ограничить количество единиц, перекачиваемых насосом. Режим ограничения расхода можно активировать через меню гаечного ключа, задав в нем количество единиц. После перекачивания заданного количества единиц насос выключится. При повторном включении насос снова перекачает заданное количество единиц, а затем выключится.

Ограничитель расхода также может быть настроен и запущен с помощью контроллера Lua или Beduino.

Насос также поддерживает команду `flowrate`. Это позволяет запрашивать общий расход через насос.

[ta4_pump|image]

### TA4 Нагреватель печи

TA3 Промышленная печь может быть усовершенствована, и модернезирована на электрический нагрев. Нефтяная топка и нагнетатель могут быть заменены на ТА4 Нагреватель печи.

Для работы нагревателя требуется 14 ku электроэнергии.

[ta4_furnaceheater|image].

### TA4 Водяной насос (устаревший)

Этот блок больше не может быть изготовлен и будет заменен блоком TA4 Водозабор.

### TA4 Водозабор

Для некоторых рецептов требуется вода. Воду нужно качать из моря с помощью насоса (вода при y = 1). Бассейна из нескольких блоков воды для этого недостаточно!

Для этого водозаборный блок необходимо поместить в воду и подключить к насосу с помощью труб. Если блок помещен в воду, необходимо убедиться, что под ним есть вода (глубина должна составлять не менее 2 блоков).

[ta4_waterinlet|image]

### TA4 Труба

На уровне развития TA4 имеются усовершенствованные трубы. Их можно использовать как стандартные трубы вместо ТА3 труб.
Замечание: TA4 Толкатели и TA4 Распределители достигают своей максимальной производительности только при использовании труб TA4.

[ta4_tube|image]

### TA4 Толкатель

Функции в основном соответствуют толкателям TA2 / TA3. Кроме того, с помощью меню можно настроить, какие предметы должны быть взяты из сундука TA4 и транспортированы дальше.
Мощность обработки составляет 12 предметов каждые 2 с, если с обеих сторон используются трубы TA4. В противном случае каждые 2 с обрабатывается только 6 предметов.

В режиме "Ограничитель потока" можно ограничить количество предметов, перемещаемых толкателем. Режим ограничения расхода можно активировать через меню гаечного ключа, задав в нем количество предметов. Как только заданное количество предметов будет перемещено, толкатель выключится. При повторном включении толкатель снова перемещает заданное количество предметов, а затем выключается.

Толкатель TA4 также можно настроить и запустить с помощью контроллера Lua или Beduino.

Вот дополнительные команды для контроллера Lua:

- `config` используется для настройки толкателя, аналогично ручной настройке через меню.
   Пример: `$send_cmnd(1234, "config", "default:dirt")`.
   С помощью `$send_cmnd(1234, "config", "")` конфигурация удаляется
- `limit` используется для установки количества элементов для режима ограничителя расхода:
   Пример: `$send_cmnd(1234, "init", 7)`.

[ta4_pusher|image]

### TA4 Сундук

Функциональность такая же, как TA3. Сундук вмещает больше содержимого.

Кроме того, в сундуке TA4 есть теневой инвентарь для настройки. Здесь определенные ячейки могут быть назначены под определенные предметы. При заполнении ячейки с заранее назначенными предметами заполняются только этими предметами. Для опустошения заранее назначенных ячеек требуется толкатель TA4 или инъектор TA4 с соответствующей конфигурацией.

[ta4_chest|image]

### TA4 8x2000 Сундук

Сундук TA4 8x2000 не имеет обычного инвентаря, как другие сундуки, а состоит из 8 магазинов, в каждом из которых может храниться до 2000 предметов одного вида. Оранжевые кнопки со стрелкой используются для перемещения предметов в магазин или из него. Сундук также можно заполнить или опустошить с помощью толкателя (TA2, TA3 или TA4), как обычный.

Если сундук заполнен толкателем, все магазины заполняются слева направо. Если все 8 магазинов заполнены и больше нельзя добавить ни одного предмета, дальнейшие предметы не обрабатываются.

**Функция строки**

Несколько сундуков TA4 8x2000 можно соединить в один большой сундук с увеличенным количеством содержимого. Для этого сундуки нужно поставить в ряд один за другим.

Сначала нужно поставить передний сундук, затем за ним ставятся сундуки с такой же ориентацией в направлении к игроку (все ящики располагаются фронтальной частью к игроку). При размещении 2 сундуков в ряд размер увеличивается до 8x4000 и т.д.

Ряды сундуков больше нельзя убрать. Есть два способа разобрать сундуки:

- Опустошите и снимите передний сундук. Это разблокирует следующий сундук, который можно убрать.
- Опустошите передний сундук настолько, чтобы во всех магазинах было не более 2000 предметов. Это разблокирует следующий сундук, и его можно будет убрать.

В сундуках есть флажок "заказать". Если этот флажок активирован, магазины больше не будут полностью опустошаться толкателем. По умолчанию в хранилище остается последний предмет. Это приводит к фиксированному распределению предметов по местам хранения.

Сундук может быть использован только игроками, которые могут строить в этом месте, т.е. имеют право на защиту. Не имеет значения, кто устанавливает сундук.

В сундуке есть дополнительная команда для контроллера Lua:

- `count` используется для запроса количества предметов в сундуке.
  Пример 1: `$send_cmnd(CHEST, "count")` -> Сумма товаров по всем 8 магазинам
  Пример 2: `$send_cmnd(CHEST, "count", 2)` -> количество товаров в магазине 2 (второй слева)
- `storesize` используется для чтения размера одного из восьми хранилищ:
  Пример: `$send_cmnd(CHEST, "storesize")` -> функция возвращает, например, 6000

[ta4_8x2000_chest|image]



### TA4 Распределитель

Функциональность такая же, как TA2 Распределитель, с одним отличием:
При условии, что со всех сторон используются трубки TA4, производительность обработки составляет 24 предмета каждые 4 с. В противном случае каждые 4 с обрабатывается только 12 элементов.

[ta4_distributor|image]

### TA4 Высокопроизводительный распределитель

Функциональность такая же, как TA4 Распределитель, с двумя отличиями:
При условии, что со всех сторон используются трубки TA4, производительность обработки составляет 36 предметов каждые 4 с. В противном случае каждые 4 с обрабатывается только 18 элементов.
Кроме того, для каждого направления можно настроить до 8 элементов.

[ta4_high_performance_distributor|image]

### TA4 Просеиватель

Функциональность такая же, как TA2.
Производительность обработки составляет 4 элемента каждые 4 секунды. Блок требует 5 ku электроэнергии.

[ta4_gravelsieve|image]

### TA4 Измельчитель

Функциональность такая же, как TA2.
Производительность обработки составляет 4 элемента каждые 4 секунды. Блок требует 9 ku электроэнергии.

[ta4_grinder|image].

### TA4 Карьер

Функциональность практически такая же, как TA2 Карьер.

Кроме того, размер выработки может быть установлен в диапазоне от 3x3 до 11x11 блоков.
Максимальная глубина - 80 метров. Для работы карьера требуется 14 ku электроэнергии.

[ta4_quarry|image]

### TA4 Водоудалитель

Водоудалитель удаляет воду с площади до 21 x 21 x 80 м. Основное предназначение - осушение пещер.
Но с его помощью можно также "пробурить" отверстие в море.
Для работы водоудалителя необходимо электричество и подключение к резервуару с жидкостью.
Водоудалитель, находящийся в самой высокой точке пещеры удаляет воду
из пещеры до самой ее нижней точки. Водоудалитель убирает один блок воды каждые две секунды.
Прибор требует 10 ku электроэнергии.

Технически Водоудалитель заменяет водяные блоки специальным воздушным блоком, который не видим, но препятствует обратному стоку воды.

[ta4_waterremover|image]

### TA4 Электронная фабрика

Функциональность такая же, как TA2 Электронная фабрика, только здесь возможно производить другие чипы.
Производительность составляет один чип каждые 6 с. Для этого блоку требуется 12 ku электроэнергии.

[ta4_electronicfab|image]

### TA4 Инжектор

Функциональность такая же, как TA3.

Производительность составляет до 8 раз по 4 предмета каждые 4 секунды.

[ta4_injector|image]

### TA4 Переработчик

Переработчик - это машина, которая обрабатывает все рецепты Techage в обратном порядке, то есть может разбирать машины и блоки на составляющие.

Машина может разобрать практически все блоки Techage и Hyperloop. Но не все предметы/материалы могут быть переработаны:

- Дерево превращается в палки
- Камень превращается в песок или гравий
- Полупроводники / микросхемы не могут быть переработаны
- Инструменты не могут быть переработаны

Производительность составляет один элемент каждые 8 секунд. Для этого блоку требуется 16 ku электроэнергии.

[ta4_recycler|image]
