local hadesS = minetest.get_translator("hade_core")
local translator = minetest.get_translator("minetestgame_slopes")
local S = function(name)
	return translator("@1 Slope", hadesS(name))
end
local S2 = function(name, l)
	return translator("@1 Slope", hadesS(name, l))
end

naturalslopeslib.register_slope("hades_core:dirt", {
	description = S("Dirt"),
	},
	30
)

-- Dirt with grass uses an other group because the original ABM erases param2 with a color
-- Those ABM are copied with the other group to be able to manage a colorfacedir

-- ... with grass cover
naturalslopeslib.register_slope("hades_core:dirt_with_grass", {
	description = S("Dirt with Grass"),
	tiles = {"hades_core_grass_cover_colorable.png"},
	palette = "ns_hades_palette_grass.png",
	overlay_tiles = "nil",
	groups = {crumbly=3,soil=1,dirt=1,dirt_with_grass_slope=1, porous=1},
	},
	40
)

-- Intermediate grass growth levels
for l=1, 3 do
	naturalslopeslib.register_slope("hades_core:dirt_with_grass_l"..l, {
		description = S2("Dirt with Growing Grass (Stage @1)", l),
		overlay_tiles = {
			{name="hades_core_grass_cover_colorable.png^[mask:hades_core_grass_mask_l"..l..".png", align_style="world"},
			"",
{name="hades_core_grass_cover_colorable.png^[mask:hades_core_grass_mask_l"..l..".png", align_style="world"},
		},
		palette = "ns_hades_palette_grass.png",
		groups = {crumbly=3,soil=1,dirt=1,dirt_with_grass_slope=l+1, porous=1},
	},
	35
	)
end

