--
-- Stone transformation
--

local function get_transformed_node(origin_name, base_dest)
	local shape = minetest.get_item_group(origin_name, "natural_slope")
	local dest_shapes = naturalslopeslib.get_all_shapes(base_dest)
	if #dest_shapes > 1 then
		return dest_shapes[shape + 1]
	end
	return base_dest
end

minetest.register_abm({
	label = "Burn stone",
	nodenames = {"group:family:hades_core:stone", "group:family:hades_core:mossystone"},
	neighbors = {"group:lava"},
	interval = 25,
	chance = 15,
	action = function(pos, node)
		local nn
		local block_name = naturalslopeslib.get_regular_node_name(node.name)
		if block_name == "hades_core:mossystone" then
			nn = "hades_core:stone"
		else
			nn = "hades_core:stone_baked"
		end
		nn = get_transformed_node(node.name, nn)
		minetest.set_node(pos, {name=nn, param2=node.param2})
	end,
})

minetest.register_abm({
	label = "Create mossy stone",
	nodenames = {"group:family:hades_core:stone"},
	interval = 600,
	chance = 65,
	action = function(pos, node)
		if minetest.find_node_near(pos, 2, {"group:water"}) == nil then
			return
		else
			local nn = get_transformed_node(node.name, "hades_core:mossystone")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		end
	end,
})

--
-- Tuff transformation
--

minetest.register_abm({
	label = "Burn tuff",
	nodenames = {"group:family:hades_core:tuff", "group:family:hades_core:mossytuff"},
	neighbors = {"group:lava"},
	interval = 25,
	chance = 15,
	action = function(pos, node)
		local shape = minetest.get_item_group(node.name, "natural_slope")
		local nn = "hades_core:tuff_baked"
		if minetest.get_item_group(node.name, "family:hades_core:mossytuff") then
			local nn = get_transformed_node(node.name, "hades_core:tuff")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		else
			local nn = get_transformed_node(node.name, "hades_core:tuff_baked")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		end
	end,
})

minetest.register_abm({
	label = "Grow moss on tuff",
	nodenames = {"group:family:hades_core:tuff"},
	interval = 600,
	chance = 65,
	action = function(pos, node)
		if minetest.find_node_near(pos, 2, {"group:water"}) == nil then
			return
		else
			local nn = get_transformed_node(node.name, "hades_core:mossytuff")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		end
	end,
})

minetest.register_abm({
	label = "Create marble",
	nodenames = {"group:family:hades_core:chondrite"},
	neighbors = {"group:water"},
	interval = 171,
	chance = 55,
	action = function(pos, node)
		if minetest.find_node_near(pos, 4, {"group:lava"}) == nil or pos.y > -500 then
			return
		else
			local nn = get_transformed_node(node.name, "hades_core:marble")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		end
	end,
})

minetest.register_abm({
	label = "Create obsidian",
	nodenames = {"group:family:hades_core:gravel_volcanic"},
	neighbors = {"group:lava"},
	interval = 180,
	chance = 65,
	action = function(pos, node)
		if minetest.find_node_near(pos, 4, {"group:water"}) == nil or pos.y > -1000 then
			return
		else
			minetest.set_node(pos, {name="hades_core:obsidian"})
		end
	end,
})

--
-- Cobble transformation
--

minetest.register_abm({
	label = "Grow moss on cobblestone (neighboring water)",
	nodenames = {"group:family:hades_core:cobble"},
	neighbors = {"group:water"},
	interval = 500,
	chance = 35,
	action = function(pos, node)
		local nn = get_transformed_node(node.name, "hades_core:mossycobble")
		minetest.set_node(pos, {name=nn, param2=node.param2})
	end,
})

minetest.register_abm({
	label = "Grow moss on cobblestone (extended water check)",
	nodenames = {"group:family:hades_core:cobble"},
	interval = 500,
	chance = 55,
	action = function(pos, node)
		if minetest.find_node_near(pos, 2, {"group:water"}) == nil then
			return
		else
			local nn = get_transformed_node(node.name, "hades_core:mossycobble")
			minetest.set_node(pos, {name=nn, param2=node.param2})
		end
	end,
})

minetest.register_abm({
	label = "Burn cobblestone",
	nodenames = {"group:family:hades_core:cobble", "group:family:hades_core:mossycobble"},
	neighbors = {"group:lava"},
	interval = 45,
	chance = 15,
	action = function(pos, node)
		local nn
		local shape = minetest.get_item_group("natural_slope")
		if node.name == "hades_core:mossycobble" then
			nn = get_transformed_node(node.name, "hades_core:cobble")
		else
			nn = get_transformed_node(node.name, "hades_core:cobble_baked")
		end
		minetest.set_node(pos, {name=nn, param2=node.param2})
	end,
})

minetest.register_abm({
	label = "Create gravel near water",
	nodenames = {"group:family:hades_core:mossycobble"},
	neighbors = {"hades_core:water_flowing"},
	interval = 500,
	chance = 75,
	action = function(pos, node)
		local nn = get_transformed_node(node.name, "hades_core:gravel")
		minetest.set_node(pos, {name=nn, param2=node.param2})
	end,
})

--
-- Ash transformation
--

minetest.register_abm({
	label = "Create fertile sand",
	nodenames = {"group:ash_fertilizer"}, -- used by most leaves
	interval = 60,
	chance = 390, -- this is increased because there is now 2 ABMs for transformation
	action = function(pos, node)
		local d = minetest.get_item_group(node.name, "ash_fertilizer")
		local pos1 = vector.add(pos, {x=d ,y=-1, z=d})
		local pos2 = vector.add(pos, {x=-d, y=-d*2, z=-d})
		-- Turn ash to fertile sand
		local ashes = minetest.find_nodes_in_area(pos1, pos2, {"group:family:hades_core:ash"})
		if #ashes == 0 then
			return
		end
		local ash = ashes[math.random(1, #ashes)]
		local ash_node = minetest.get_node({x=ash.x,y=ash.y,z=ash.z})
		local above_ash = minetest.get_node({x=ash.x,y=ash.y+1,z=ash.z})
		local aname = above_ash.name
		local def = minetest.registered_nodes[aname]
		if def and def.walkable then
			return
		end
		local nn = get_transformed_node(ash_node.name, "hades_core:fertile_sand")
		minetest.set_node(ash, {name=nn, param2=ash_node.param2})
	end,
})

--
-- Fertile sand transformation
--

minetest.register_abm({
	label = "Create dirt (direct neighboring water)",
	nodenames = {"group:family:hades_core:fertile_sand"},
	neighbors = {"group:water"},
	interval = 25,
	chance = 5,
	action = function(pos, node)
		local nn = get_transformed_node(node.name, "hades_core:dirt")
		minetest.set_node(pos, {name=nn, param2=node.param2})
	end,
})

minetest.register_abm({
	label = "Create dirt (extended water check)",
	nodenames = {"group:family:hades_core:fertile_sand"},
	neighbors = {"hades_core:dirt", "hades_core:dirt_with_grass"},
	interval = 50,
	chance = 5,
	action = function(pos, node)
			if minetest.find_node_near(pos, 10, {"group:water"}) == nil then
				return
			else
				local nn = get_transformed_node(node.name, "hades_core:dirt")
				minetest.set_node(pos, {name=nn, param2=node.param2})
			end
	end,
})

--
-- Dirt transformation
--

-- Takes a node name and if it's capable of being covered by grass,
-- returns the node name of the next level of "grassiness",
-- otherwise it returns nil
-- Override to use the same function for slopes and blocks
function hades_core.get_next_grass_cover_level(nodename)
	local replacements = naturalslopeslib.get_replacement(nodename)
	local base_nodename = nodename
	local slope_group = minetest.get_item_group(nodename, "natural_slope")
	if replacements then
		base_nodename = replacements.source
	end
	local new_node
	if base_nodename == "hades_core:dirt" then
		new_node = "hades_core:dirt_with_grass_l1"
	elseif base_nodename == "hades_core:dirt_with_grass_l1" then
		new_node = "hades_core:dirt_with_grass_l2"
	elseif base_nodename == "hades_core:dirt_with_grass_l2" then
		new_node = "hades_core:dirt_with_grass_l3"
	elseif base_nodename == "hades_core:dirt_with_grass_l3" then
		new_node = "hades_core:dirt_with_grass"
	end
	if new_node then
		if slope_group > 0 then
			return naturalslopeslib.get_all_shapes(new_node)[slope_group + 1]
		else
			return new_node
		end
	end
end

-- Dirt-with-Grass ABMs
-- This one has no changes, slopes can keep their param2 when growing and get_next_grass_cover_level now returns the next sloped node.
minetest.register_abm({
	label = "Increase Dirt-with-Grass-Slope grass level on Dirt-with-Grass-Slope under bright light",
	nodenames = {"group:dirt_with_grass_slope"},
	interval = 2,
	chance = 200,
	action = function(pos, node)
		local above = {x=pos.x, y=pos.y+1, z=pos.z}
		local name = minetest.get_node(above).name
		local nodedef = minetest.registered_nodes[name]
		if nodedef and (nodedef.sunlight_propagates or nodedef.paramtype == "light")
				and nodedef.liquidtype == "none"
				and (minetest.get_node_light(above) or 0) >= 13 then
			local nextnode = hades_core.get_next_grass_cover_level(node.name)
			if nextnode then
				minetest.set_node(pos, {name = nextnode, param2 = node.param2})
			end
		end
	end
})

-- No change either, same as above
minetest.register_abm({
	label = "Increase Dirt-with-Grass-Slope level on Dirt-with-Grass-Slope under air in faint light",
	nodenames = {"group:dirt_with_grass_slope"},
	interval = 50,
	chance = 20,
	action = function(pos, node)
		local name = minetest.get_node(pos).name
		local node = minetest.get_node({x=pos.x,y=pos.y+1,z=pos.z})
		if node.name == "air" and (minetest.get_node_light(pos) or 0) >= 8 then
			local nextnode = hades_core.get_next_grass_cover_level(node.name)
			if nextnode then
				minetest.set_node(pos, {name = nextnode, param2 = node.param2})
			end
		end
	end,
})

-- Updated to use new color as a colorfacedir instead of a color value
-- and revert to sloped dirt
minetest.register_abm({
	label = "Turn covered 'dirt with grass slope' back to dirt, update seasonal grass color",
	nodenames = {"group:dirt_with_grass_slope"},
	interval = 2,
	chance = 20,
	action = function(pos, node)
		local above = {x=pos.x, y=pos.y+1, z=pos.z}
		local name = minetest.get_node(above).name
		local nodedef = minetest.registered_nodes[name]
		if name ~= "ignore" and nodedef
				and not ((nodedef.sunlight_propagates or nodedef.paramtype == "light")
				and nodedef.liquidtype == "none") then
			local slope_group = minetest.get_item_group(node.name, "natural_slope")
			local nextnode = naturalslopeslib.get_all_shapes("hades_core:dirt")[slope_group + 1]
			minetest.set_node(pos, {name = nextnode, param2 = node.param2})
		else
			local old_color = math.floor(node.param2 / 32)
			local new_color = hades_core.get_seasonal_grass_color_param2(old_color) % 8
			if new_color ~= old_color then
				local new_param2 = (node.param2 % 32) + (new_color * 32)
				minetest.set_node(pos, {name = node.name, param2 = new_param2})
			end
		end
	end
})
