local S = minetest.get_translator(minetest.get_current_modname())
local F = minetest.formspec_escape

k_colorblocks = {
    palettes = {
        full = {
            image = "k_colorblocks_palette_color_full.png",
            formspec = function(self, player)
                local primary = {
                    "Reds",
                    "Greens",
                    "Blues",
                }
                -- colour names were lifted off wikipedia
                local colours = {
                    "Red",
                    "Orange",
                    "Yellow",
                    "Chartreuse",
                    "Green",
                    "Spring green",
                    "Cyan",
                    "Azure",
                    "Blue",
                    "Violet",
                    "Magenta",
                    "Rose",
                }

                local grids = {
                    -- grey
                    { top = 0.8, left = 0.4, istart = 0, iend = 14, w = 15, label = "Greyscale", },
                }

                -- texture index pointer for rest of palette
                local idx = 15

                for p = 1, #primary, 1 do
                    local colstart = 1 + ((p - 1) * 4)
                    local colend = colstart + 3

                    for c = colstart, colend, 1 do
                        local row = (c - 1) % 4
                        table.insert(grids, { top = 1.55 + (2.25 * row), left = 0.4 + ((p - 1) * 2.75), istart = idx, iend = (idx + 19), w = 5, label = colours[c] })
                        idx = idx + 20
                    end
                end
                local formspecParts = {}
                local endleft = 0
                local endtop = 0
                for i = 1, #grids, 1 do
                    local formspec, eleft, etop = k_colorblocks:buildColorGrid(grids[i].left, grids[i].top, self.image, grids[i].istart, grids[i].iend, grids[i].w, player)
                    endleft = eleft
                    endtop = etop
                    table.insert(formspecParts, formspec)
                    -- add labels on top
                    table.insert(formspecParts, "label[" .. (grids[i].left) .. "," .. (grids[i].top - 0.1) .. ";" .. F(S(grids[i].label)) .. "]")
                end
                -- 255 is transparent for no reason
                local formspec, _, _ = k_colorblocks:buildColorGrid(grids[1].left + (grids[1].w * 0.5), grids[1].top, self.image, 255, 255, 1, player)
                table.insert(formspecParts, formspec)


                return table.concat(formspecParts), endleft, endtop
            end,
        },
        grey = {
            image = "k_colorblocks_palette_grey_full.png",
            formspec = function(self, player)
                local formspec, eleft, etop = k_colorblocks:buildColorGrid(0.8, 0.4, self.image, 0, 255, 16, player)
                formspec = formspec .. "label[0.4,0.7;" .. F(S("Greyscale")) .. "]"
            end,
        }
    },
    -- map of nodes we can apply colours to for quicker lookup.
    nodes = {},
    -- per player gui context
    gui_contexts = {

    },
    -- @param offsetLeft    x offset in form
    -- @param offsetTop     y offset in form
    -- @param palette     texture which is a single line of color
    -- @param startIdx    zero index start position on palette
    -- @param endIdx    zero index end position on palette
    -- @param width    width of grid
    buildColorGrid = function(self, offsetLeft, offsetTop, palette, startIdx, endIdx, width, player)
        local parts = {}
        local offsetEndLeft = offsetLeft
        local offsetEndTop = offsetTop

        local playerName = player and player:get_player_name() or nil

        local selectedCol = playerName and self.gui_contexts[playerName] and self.gui_contexts[playerName].selected_col or nil
        local currentCol = playerName and self.gui_contexts[playerName] and self.gui_contexts[playerName].current_col or nil
        local currentColAux = playerName and self.gui_contexts[playerName] and self.gui_contexts[playerName].current_col_aux or nil

        --image_button[<X>,<Y>;<W>,<H>;<texture name>;<name>;<label>]

        for idx = startIdx, endIdx, 1 do
            local localIdx = idx - startIdx
            local left = (math.floor(localIdx % width) * 0.5) + offsetLeft
            local top = (math.floor(localIdx / width) * 0.5) + offsetTop

            local texture = palette .. "^[sheet:256x1:" .. idx .. ",0"

            if selectedCol and selectedCol == idx then
                texture = "(" .. texture .. ")^k_colorblocks_selected_gui.png"
            end
            if currentCol and currentCol == idx then
                texture = "(" .. texture .. ")^k_colorblocks_selected_wand.png"
            end
            if currentColAux and currentColAux == idx then
                texture = "(" .. texture .. ")^k_colorblocks_selected_wand_aux.png"
            end

            table.insert(parts, string.format(
                "image_button[%.4f,%.4f;0.5,0.5;%s;k_col;%d;false;false]",
                left,
                top,
                F(texture),
                idx
            ))
            offsetEndLeft = left + 0.5
            offsetEndTop = top + 0.5
        end

        return table.concat(parts, ""), offsetEndLeft, offsetEndTop
    end,
    showWandGUI = function(self, player, pointed_thing)
        local playerName = player and player:get_player_name() or ""

        if "" == playerName then
            return
        end

        if nil == self.gui_contexts[playerName] then
            self.gui_contexts[playerName] = {}
        end

        self.gui_contexts[playerName].pointed_thing = nil
        self.gui_contexts[playerName].pointed_node = nil

        if
            pointed_thing
            and "node" == pointed_thing.type
            and pointed_thing.under
        then
            local pointed_node = minetest.get_node(pointed_thing.under)
            if pointed_node and nil ~= self.nodes[pointed_node.name] then
                self.gui_contexts[playerName].pointed_thing = pointed_thing
                self.gui_contexts[playerName].pointed_node = pointed_node
            end
        end

        self:refreshWandGui(player)
    end,
    refreshWandGui = function(self, player)
        local formspecgrids, endleft, endtop = self.palettes.full:formspec(player)

        local formspec                       = "size[" .. (endleft + 0.4) .. "," .. (endtop + 0.9) .. "]"
            .. "padding[0,0]"
            .. "real_coordinates[true]"
            .. "label[0.3,0.3;" .. F(S("K Color Picker")) .. "]"
            .. formspecgrids
            .. "button_exit[" .. (endleft - 2.0) .. "," .. (endtop + 0.1) .. ";0.7,0.6;ok_aux;" .. F(S("Aux")) .. "]"
            .. "button_exit[" .. (endleft - 1.3) .. "," .. (endtop + 0.1) .. ";0.7,0.6;ok;" .. F(S("OK")) .. "]"
            .. "button_exit[" .. (endleft - 0.6) .. "," .. (endtop + 0.1) .. ";0.9,0.6;cancel;" .. F(S("Cancel")) .. "]"

        local playerName                     = player and player:get_player_name() or nil
        local pn                             = playerName and self.gui_contexts[playerName] and self.gui_contexts[playerName].pointed_node or nil

        -- @todo refactor bottom tiles
        if pn and nil ~= pn.param2 then
            local texture = self.palettes.full.image .. "^[sheet:256x1:" .. pn.param2 .. ",0"

            formspec = formspec
                .. "label[0.4," .. (endtop + 0.2) .. ";" .. S("Pointed") .. "]"
                .. "label[0.4," .. (endtop + 0.4) .. ";" .. S("Block") .. "]"
                .. "label[0.4," .. (endtop + 0.6) .. ";" .. S("Color") .. "]"
                .. string.format(
                    "image_button[%.4f,%.4f;0.5,0.5;%s;k_col;%d;false;false]",
                    1.4,
                    (endtop + 0.1),
                    F(texture),
                    pn.param2
                )
        end

        if nil ~= self.gui_contexts[playerName].current_col then
            local texture = self.palettes.full.image .. "^[sheet:256x1:" .. self.gui_contexts[playerName].current_col .. ",0"

            formspec = formspec
                .. "label[2.3," .. (endtop + 0.3) .. ";" .. S("Current") .. "]"
                .. "label[2.3," .. (endtop + 0.5) .. ";" .. S("Color") .. "]"
                .. string.format(
                    "image_button[%.4f,%.4f;0.5,0.5;%s;k_col;%d;false;false]",
                    3.0,
                    (endtop + 0.1),
                    F(texture),
                    self.gui_contexts[playerName].current_col
                )
        end

        if nil ~= self.gui_contexts[playerName].current_col_aux then
            local texture = self.palettes.full.image .. "^[sheet:256x1:" .. self.gui_contexts[playerName].current_col_aux .. ",0"

            formspec = formspec
                .. "label[3.9," .. (endtop + 0.3) .. ";" .. S("Aux") .. "]"
                .. "label[3.9," .. (endtop + 0.5) .. ";" .. S("Color") .. "]"
                .. string.format(
                    "image_button[%.4f,%.4f;0.5,0.5;%s;k_col;%d;false;false]",
                    4.6,
                    (endtop + 0.1),
                    F(texture),
                    self.gui_contexts[playerName].current_col_aux
                )
        end

        minetest.show_formspec(player:get_player_name(), "k_colorblocks_selector", formspec)
    end,
    cacheNode = function(self, nodename)
        if "string" == type(nodename) then
            self.nodes[nodename] = 1
        end
    end,
}

-- use this way to allow press and hold application.
-- may have a performance impact
minetest.register_on_punchnode(function(pos, node, puncher, pointed_thing)
    local playerName = puncher and puncher:get_player_name() or ""

    if
    -- @todo simplify these checks
        "" ~= playerName
        and nil ~= k_colorblocks.nodes[node.name]
        and nil ~= k_colorblocks.gui_contexts[playerName]
        and "k_colorblocks:wand" == puncher:get_wielded_item():get_name()
    then
        local pc = puncher:get_player_control()
        local newCol = 0

        if pc.aux1 and nil ~= k_colorblocks.gui_contexts[playerName].current_col_aux then
            newCol = k_colorblocks.gui_contexts[playerName].current_col_aux
        elseif nil ~= k_colorblocks.gui_contexts[playerName].current_col then
            newCol = k_colorblocks.gui_contexts[playerName].current_col
        end

        -- checks colour change to maybe prevents extra node changes
        if newCol ~= node.param2 then
            -- print(dump("set "..newCol).. dump(node))
            node.param2 = newCol
            minetest.set_node(pos, node)
        end

        --local meta = minetest.get_meta(pos)
        --meta:set_int("k_colorblocks_col", node.param2)
    end
end)

local dblclkTime = tonumber(0)
minetest.register_on_player_receive_fields(function(player, formname, fields)
    if "k_colorblocks_selector" ~= formname then
        return
    end

    local playerName = player and player:get_player_name() or nil
    local selected = 0

    if playerName and nil ~= fields.k_col then
        selected = tonumber(fields.k_col)
        k_colorblocks.gui_contexts[playerName].selected_col = selected
        k_colorblocks:refreshWandGui(player)

        local newDblclkTime = tonumber(minetest.get_us_time())
        -- registers a "double click" on a color
        if 333333 > (newDblclkTime - dblclkTime) then
            fields.ok = 1
            minetest.close_formspec(playerName, "k_colorblocks_selector")
        end
        dblclkTime = newDblclkTime
    end

    if k_colorblocks.gui_contexts[playerName].selected_col then
        if fields.ok then
            k_colorblocks.gui_contexts[playerName].current_col = k_colorblocks.gui_contexts[playerName].selected_col
        end

        if fields.ok_aux then
            k_colorblocks.gui_contexts[playerName].current_col_aux = k_colorblocks.gui_contexts[playerName].selected_col
        end
    end
end)

-- minetest.register_on_placenode(function(pos, newnode, placer, oldnode, itemstack, pointed_thing)
--     print(dump(newnode) .. itemstack:to_string())
-- end)

-- really prevent digging things up.
local nodigcap = { times = { [1] = math.huge, [2] = math.huge, [3] = math.huge }, uses = 0, maxlevel = 1 }
-- tool to switch things.
minetest.register_tool("k_colorblocks:wand", {
    description = S("Wand of the Application of the Kolor"),
    inventory_image = "k_colorblocks_wand.png",
    -- keep it to creative mode srsly
    -- tbd: range might not be working as expected sometimes?
    range = 200,
    light_level = 14,
    wield_scale = { x = 1.0, y = 1.0, z = 1.0, },
    groups = { tool = 1, fire_immune = 1 },
    liquids_pointable = false,
    tool_capabilities = {
        full_punch_interval = 0,
        max_drop_level = 0,
        groupcaps = {
            bendy                   = nodigcap,
            pickaxey                = nodigcap,
            snappy                  = nodigcap,
            fleshy                  = nodigcap,
            cracky                  = nodigcap,
            choppy                  = nodigcap,
            crumbly                 = nodigcap,
            unbreakable             = nodigcap,
            dig_immediate           = nodigcap,
            oddly_breakable_by_hand = nodigcap,
        },
        damage_groups = { fleshy = 0, cracky = 0, },
        punch_attack_uses = 0,
    },
    _mcl_toollike_wield = true,
    -- so that it can't actually dig anything
    _mcl_diggroups = {
        handy = { speed = 0, level = 0, uses = 0 },
        hoey = { speed = 0, level = 0, uses = 0 },
        pickaxey = { speed = 0, level = 0, uses = 0 },
        shovely = { speed = 0, level = 0, uses = 0 },
        axey = { speed = 0, level = 0, uses = 0 },
        swordy = { speed = 0, level = 0, uses = 0 },
        swordy_cobweb = { speed = 0, level = 0, uses = 0 },
        shearsy_cobweb = { speed = 0, level = 0, uses = 0 }
    },
    on_place = function(stack, player, pt)
        k_colorblocks:showWandGUI(player, pt)
    end,
    on_secondary_use = function(stack, player, pt)
        k_colorblocks:showWandGUI(player, pt)
    end,
})


-- node registration
dofile(minetest.get_modpath(minetest.get_current_modname()) .. "/nodes.lua")
