local atom_table = {
	["atoms:red"] = {
		["atoms:red"] = "nodes:stone"
	},
	["atoms:green"] = {
		["atoms:green"] = "nodes:cane"
	},
	["atoms:blue"] = {
		["atoms:blue"] = "nodes:water"
	},
	["atoms:yellow"] = {
		["atoms:yellow"] = "nodes:lamp"
	},
	["atoms:white"] = {
		["nodes:cane"] = "nodes:water",
		["nodes:water"] = "nodes:stone"
	}
}
local function get_from_atom_table(wielded, pointed)
	local temp = atom_table[wielded]
	if not temp then return nil end
	return temp[pointed]
end
local function combine_atoms(itemstack, placer, pointed_thing) --put in on_place
	local result = get_from_atom_table(itemstack:get_name(),core.get_node(pointed_thing.under).name)
	if not result then
		return core.item_place(itemstack, placer, pointed_thing)
	end
	itemstack:set_count(itemstack:get_count()-1)
	core.set_node(pointed_thing.under, {name=result})
	return itemstack
end
core.register_node("atoms:red", {
	description = "Red atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#d03030",
	on_place = combine_atoms
})
core.register_node("atoms:green", {
	description = "Green atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#30b030",
	on_place = combine_atoms
})
core.register_node("atoms:blue", {
	description = "Blue atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#3030e0",
	on_place = combine_atoms
})
core.register_node("atoms:yellow", {
	description = "Yellow atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#d0b830",
	on_place = combine_atoms
})
core.register_node("atoms:white", {
	description = "White atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#e0e0e0",
	on_place = function(itemstack, placer, pointed_thing)
		local result = get_from_atom_table(itemstack:get_name(),core.get_node(pointed_thing.under).name)
		if not result then
			return core.item_place(itemstack, placer, pointed_thing)
		end
		core.set_node(pointed_thing.under, {name=result})
		return
	end
})
core.register_node("atoms:black", {
	description = "Black atom",
	tiles = {"atom_black.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_place = combine_atoms
})
