local atom_table = {
	[n.."atoms:red"] = {
		[n.."atoms:red"] = n.."nodes:stone"
	},
	[n.."atoms:green"] = {
		[n.."atoms:green"] = n.."nodes:cane"
	},
	[n.."atoms:blue"] = {
		[n.."atoms:blue"] = n.."nodes:water"
	},
	[n.."atoms:yellow"] = {
		[n.."atoms:red"] = n.."decoration:red",
		[n.."atoms:green"] = n.."decoration:green",
		[n.."atoms:blue"] = n.."decoration:blue",
		[n.."atoms:yellow"] = n.."nodes:lamp",
		[n.."atoms:white"] = n.."decoration:white",
		[n.."atoms:black"] = n.."decoration:flower"
	},
	[n.."atoms:white"] = {
		[n.."nodes:cane"] = n.."nodes:water",
		[n.."nodes:water"] = n.."nodes:stone"
	}
}
local function get_from_atom_table(wielded, pointed)
	local temp = atom_table[wielded]
	if not temp then return nil end
	return temp[pointed]
end
local function combine_atoms(itemstack, placer, pointed_thing) --put in on_place
	local result = get_from_atom_table(itemstack:get_name(),core.get_node(pointed_thing.under).name)
	if not result then
		return core.item_place(itemstack, placer, pointed_thing)
	end
	itemstack:set_count(itemstack:get_count()-1)
	core.set_node(pointed_thing.under, {name=result})
	return itemstack
end
core.register_node(n.."atoms:red", {
	description = "Red atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#d03030",
	on_place = combine_atoms
})
core.register_node(n.."atoms:green", {
	description = "Green atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#30b030",
	on_place = combine_atoms
})
core.register_node(n.."atoms:blue", {
	description = "Blue atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#3030e0",
	on_place = combine_atoms
})
core.register_node(n.."atoms:yellow", {
	description = "Yellow atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#d0b830",
	on_place = combine_atoms
})
core.register_node(n.."atoms:white", {
	description = "White atom",
	tiles = {"atom.png"},
	groups = {oddly_breakable_by_hand = 1},
	color = "#e0e0e0",
	on_place = function(itemstack, placer, pointed_thing)
		local result = get_from_atom_table(itemstack:get_name(),core.get_node(pointed_thing.under).name)
		if not result then
			return core.item_place(itemstack, placer, pointed_thing)
		end
		core.set_node(pointed_thing.under, {name=result})
		return
	end
})
core.register_node(n.."atoms:black", {
	description = "Black atom",
	tiles = {"atom_black.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_place = combine_atoms
})
