core.register_node("mat_boxes:box", {
	description = "Box",
	tiles = {"box.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_rightclick = function(pos, node, clicker, itemstack)
		if itemstack:is_empty() then return end
		-- the forthy/lispy way you can just remove whitespace is cool
		-- lua is a good scripting language
		core.swap_node(pos, {name="mat_boxes:box_filled"})
		local meta = core.get_meta(pos) -- wow so meta
		local inventory = meta:get_inventory()
		inventory:set_size("box", 1)
		inventory:set_stack("box", 1, itemstack)
		itemstack:clear()
		return itemstack
	end
})
core.register_node("mat_boxes:box_filled", {
	description = "Filled box",
	tiles = {"box_filled.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_rightclick = function(pos, node, clicker, itemstack)
		local meta = core.get_meta(pos)
		local inventory = meta:get_inventory()
		local inside_itemstack = inventory:get_stack("box", 1)
		if itemstack:get_name() ~= inside_itemstack:get_name() then return end
		inside_itemstack:set_count(inside_itemstack:get_count() + itemstack:get_count())
		inventory:set_stack("box", 1, inside_itemstack)
		itemstack:clear()
		return itemstack
	end,
	node_dig_prediction = "",
	on_dig = function(pos, node, digger)
		local meta = core.get_meta(pos)
		local inventory = meta:get_inventory()
		local inside_itemstack = inventory:get_stack("box", 1)
		local player_inventory = digger:get_inventory()
		local inside_itemstack = player_inventory:add_item("main", inside_itemstack) -- it'll probably be hard to add The Worm
		if inside_itemstack:is_empty() then
			core.swap_node(pos, {name="mat_boxes:box"})
			return false
		end
		return false
	end
})
core.register_node("mat_boxes:wastebin", {
	description = "Wastebin",
	tiles = {"wastebin.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_rightclick = function(pos, node, clicker, itemstack)
		itemstack:clear()
		return itemstack
	end
})
