core.register_node("mat_nodes:stone", {
	description = "Stone",
	tiles = {"stone.png"},
	groups = {oddly_breakable_by_hand = 1},
	on_dig = function(pos, node, digger)
		local wielded = digger:get_wielded_item()
		if wielded:get_name() == "mat_nodes:cane" then
			wielded:set_count(wielded:get_count()-1)
			digger:set_wielded_item(wielded)
			core.set_node(pos, {name="mat_atoms:black"})
			return
		end
		if wielded:get_name() == "mat_nodes:water" then
			wielded:set_count(wielded:get_count()-1)
			digger:set_wielded_item(wielded)
			core.set_node(pos, {name="mat_atoms:white"})
			return
		end
		core.node_dig(pos, node, digger)
	end
})

local cane_delay = 6.
core.register_node("mat_nodes:cane", {
	description = "Cane",
	tiles = {"cane.png"},
	inventory_image = "cane.png",
	groups = {oddly_breakable_by_hand = 1},
	paramtype = "light",
	drawtype = "plantlike",
	walkable = false,
	climbable = true,
	on_timer = function (pos)
		local node = core.get_node(pos)
		local pos_above = vector.new(pos.x, pos.y+1, pos.z)
		local node_above = core.get_node(pos_above)
		if node_above.name ~= "air" then
			return
		end
		if node.param2 ~= 0 then
			core.set_node(pos_above, {name="mat_nodes:cane", param2=node.param2-1})
		end
		local node_timer = core.get_node_timer(pos_above)
		node_timer:start(cane_delay)
	end,
	on_construct = function(pos)
		local node_timer = core.get_node_timer(pos)
		node_timer:start(cane_delay)
	end,
	after_place_node = function(pos)
		core.set_node(pos, {name="mat_nodes:cane",param2=5})
	end,
	after_dig_node = function(pos, _a, _b, digger)
		local pos_above = vector.new(pos.x, pos.y+1, pos.z)
		local pos_below = vector.new(pos.x, pos.y-1, pos.z)
		if core.get_node(pos_above).name == "mat_nodes:cane" then
			core.dig_node(pos_above, digger)
		end
		if core.get_node(pos_below).name == "mat_nodes:cane" then
			local node_timer = core.get_node_timer(pos_below)
			node_timer:start(cane_delay)
		end
	end,
	on_dig = function(pos, node, digger)
		local wielded = digger:get_wielded_item()
		if wielded:get_name() == "mat_nodes:water" then
			wielded:set_count(wielded:get_count()-1)
			digger:set_wielded_item(wielded)
			core.set_node(pos, {name="mat_atoms:yellow"})
			return
		end
		core.node_dig(pos, node, digger)
	end,
	on_place = function(itemstack, placer, pointed_thing)
		if core.get_node(pointed_thing.under).name == "mat_nodes:water" then
			itemstack:set_count(itemstack:get_count()-1)
			core.set_node(pointed_thing.under, {name="mat_atoms:green"})
			return itemstack
		end
		return core.item_place(itemstack, placer, pointed_thing)
	end
})
core.register_node("mat_nodes:water", {
	description = "Water",
	walkable = false,
	liquid_move_physics = true,
	paramtype = "light",
	sunlight_propagates = true,
	use_texture_alpha = "blend",
	post_effect_color = "#0000FF20",
	tiles = {"water.png"},
	drawtype = "liquid",
	groups = {oddly_breakable_by_hand = 1},
	on_dig = function(pos, node, digger)
		local wielded = digger:get_wielded_item()
		if wielded:get_name() == "mat_nodes:cane" then
			wielded:set_count(wielded:get_count()-1)
			digger:set_wielded_item(wielded)
			core.set_node(pos, {name="mat_atoms:red"})
			return
		end
		core.node_dig(pos, node, digger)
	end,
	on_place = function(itemstack, placer, pointed_thing)
		if core.get_node(pointed_thing.under).name == "mat_nodes:cane" then
			itemstack:set_count(itemstack:get_count()-1)
			core.set_node(pointed_thing.under, {name="mat_atoms:blue"})
			return itemstack
		end
		return core.item_place(itemstack, placer, pointed_thing)
	end
})

core.register_node("mat_nodes:lamp", {
	description = "Lamp",
	tiles = {"lamp.png"},
	inventory_image = "lamp.png",
	drawtype = "plantlike",
	walkable = false,
	light_source = core.LIGHT_MAX,
	groups = {oddly_breakable_by_hand = 1}
})
