local enter_trigger

local player_default_properties = {
    visual_size = vector.new(1,1,1),
    eye_height = 1.4700000286102,
    collisionbox = {
        -0.30000001192093, 
        0, 
        -0.30000001192093, 
        0.30000001192093, 
        1.7000000476837, 
        0.30000001192093
    }
}

local get_random_player_properties = function(size)
    return {
        visual_size = vector.new(size,size,size),
        eye_height = 1.4700000286102 * size,
        collisionbox = {
            -0.30000001192093*size, 
            0*size, 
            -0.30000001192093*size, 
            0.30000001192093*size, 
            1.7000000476837*size, 
            0.30000001192093*size
        }
    }
end

core.register_entity("exit_mt_gameplay:trigger1", {
    visual = "cube",
    is_visible = false,
    on_step = function(self, dtime, moveresult) 
        for _,pos in pairs(exit_mt_gameplay.first_level.triggers_start_pos) do
            for _,v in pairs(core.get_objects_inside_radius(pos, 4)) do
                if v:is_player() then
                    local name = v:get_player_name()
                    
                    if not exit_mt_gameplay.first_level.players.players[name] then
                        exit_mt_gameplay.first_level.players.players[name] = 1
                        exit_mt_gameplay.first_level.players.amount = exit_mt_gameplay.first_level.players.amount + 1
                    end
                end
            end
        end
    
        if exit_mt_gameplay.first_level.players.amount >= #exit_mt_gameplay.players then
            exit_mt_gameplay.first_level.triggers[1]:remove()
    
            local anomaly = false
    
            local possible_anomalies = {
                "sound",
                "node",
                "schematic",
                "player",
                "normal",
            }
    
            local anomaly_type = possible_anomalies[math.random(1, #possible_anomalies)]
    
            local data = nil
    
            if exit_mt_gameplay.level == 1 then
                data = exit_mt_generation.place_structure_first(exit_mt_gameplay.games_nodes[2], anomaly_type)
            else
                data = exit_mt_generation.place_structure_second(exit_mt_gameplay.games_nodes[2], anomaly_type)
            end
            
            if data == nil then
                return
            end

            anomaly = data.game_nodes[3]

            if anomaly_type == "player" then
                anomaly = true
            end
    
            local pos = exit_mt_gameplay.start_pos or data.trigger1[math.random(1, #data.trigger1)]
    
            for i=1,#exit_mt_gameplay.first_level.block_pos do
                core.set_node(exit_mt_gameplay.first_level.block_pos[i], {name="air"})
            end
    
            exit_mt_gameplay.first_level = {
                players = {
                    players = {},
                    amount = 0,
                },
                players_exit = {
                    players = {},
                    amount = 0,
                },
                players_enter = {
                    players = {},
                    amount = 0,
                },
                triggers = {},
                triggers_exit_pos = exit_mt_gameplay.second_level.triggers_exit_pos,
                block_pos = exit_mt_gameplay.second_level.block_pos,
                game_nodes = exit_mt_gameplay.second_level.game_nodes,
                anomaly = exit_mt_gameplay.second_level.anomaly,
                anomalies_state = exit_mt_gameplay.second_level.anomalies_state
            }
    
            exit_mt_gameplay.second_level = {
                triggers_exit_pos = data.trigger2,
                triggers_start_pos = {},
                block_pos = data.block,
                game_nodes = data.game_nodes,
                anomaly = anomaly,
                anomalies_state = anomaly_type
            }
    
            for i=1,#data.trigger1 do
                core.set_node(data.trigger1[i], {name="air"})
                exit_mt_gameplay.second_level.triggers_start_pos[i] = data.trigger1[i]
            end
            
    
            local trigger = core.add_entity(pos, "exit_mt_gameplay:trigger2")
            exit_mt_gameplay.first_level.triggers[1] = trigger
        end
    
    end,
    static_save = false
})

core.register_entity("exit_mt_gameplay:trigger2", {
    visual = "cube",
    is_visible = false,
    on_step = function(self, dtime, moveresult)
        -- Check if all players crossed enter or exit trigger
        for k,pos in pairs(exit_mt_gameplay.first_level.triggers_exit_pos) do
            for _,v in pairs(core.get_objects_inside_radius(pos, 3)) do
                if v:is_player() then
                    local name = v:get_player_name()

                    if k == "enter" then
                        if not exit_mt_gameplay.first_level.players_enter.players[name] then
                            exit_mt_gameplay.first_level.players_enter.amount = exit_mt_gameplay.first_level.players_enter.amount + 1
                            exit_mt_gameplay.first_level.players_enter.players[name] = 1
                        end 
                    else
                        if not exit_mt_gameplay.first_level.players_exit.players[name] then
                            exit_mt_gameplay.first_level.players_exit.amount = exit_mt_gameplay.first_level.players_exit.amount + 1
                            exit_mt_gameplay.first_level.players_exit.players[name] = 1
                        end
                    end

                end
            end
        end

        local players_choosen_exit = exit_mt_gameplay.first_level.players_exit.amount >= #exit_mt_gameplay.players
        local players_choosen_enter = exit_mt_gameplay.first_level.players_enter.amount >= #exit_mt_gameplay.players

        if players_choosen_enter or players_choosen_exit then
            exit_mt_gameplay.level = 1 - exit_mt_gameplay.level
            exit_mt_gameplay.first_level.triggers[1]:remove()
            exit_mt_generation.enter_trigger()

            -- Reset player properties
            if exit_mt_gameplay.first_level.anomalies_state == "player" then
                local players = core.get_connected_players()
                for _,player in pairs(players) do
                    player:set_physics_override({
                        speed = 1,
                        jump = 1,
                        gravity = 1,
                    })

                    player:set_properties(player_default_properties)
                end
            end

        
            -- Set player type anomalies
            if exit_mt_gameplay.second_level.anomalies_state == "player" then
                local players = core.get_connected_players()
                local size = 0.5
    
    
                if math.random() > 0.5 then
                    for _,player in pairs(players) do
                        player:set_properties(get_random_player_properties(size))
                    end
                else
                    local possible_modifiers = {
                        "speed",
                        "jump",
                        "gravity"
                    }
                    local possible_modifier_values = {
                        {1.5, 2},
                        {1.5, 2},
                        {0.1, 0.5}
                    }
                    local modifier_number = math.random(1,3)
                    local modifier = possible_modifiers[modifier_number]
                    local physics_override = {}
                    physics_override[modifier] = possible_modifier_values[modifier_number][1] + math.random() * (possible_modifier_values[modifier_number][2] - possible_modifier_values[modifier_number][1])
                    for _,player in pairs(players) do
                        player:set_physics_override(physics_override)
                    end
                end
            end

            local start_triggers = {}
            for i=1,#exit_mt_gameplay.second_level.triggers_start_pos do
                local pos = exit_mt_gameplay.second_level.triggers_start_pos[i]
                start_triggers[i] = pos
            end

            for i=1,#exit_mt_gameplay.first_level.block_pos do
                core.set_node(exit_mt_gameplay.first_level.block_pos[i], {name="exit_mt_blocks:old_bricks_02"})
            end

            local trigger1 = core.add_entity(vector.new(0,0,0), "exit_mt_gameplay:trigger1")

            exit_mt_gameplay.first_level.triggers = {trigger1}
            exit_mt_gameplay.first_level.triggers_start_pos = start_triggers


            if (players_choosen_exit and exit_mt_gameplay.first_level.anomaly) or 
            (players_choosen_enter and not exit_mt_gameplay.first_level.anomaly) then
                core.sound_play({
                    name = "trigger_correct",
                })
                exit_mt_gameplay.wins = exit_mt_gameplay.wins + 1
                if exit_mt_gameplay.wins > 10 then
                    core.chat_send_all("You won!")
                end
            else 
                core.sound_play({
                    name = "trigger_wrong",
                })
                exit_mt_gameplay.wins = exit_mt_gameplay.wins - 2
                if exit_mt_gameplay.wins < 0 then exit_mt_gameplay.wins = 0 end
            end
            exit_mt_gameplay.first_level.players_enter = {
                amount = 0,
                players = {},
            }
            exit_mt_gameplay.first_level.players_exit = {
                amount = 0,
                players = {},
            }
        end
    end,
    static_save = false
})

exit_mt_gameplay = exit_mt_gameplay and exit_mt_gameplay or {
    wins=0
}

core.register_on_joinplayer(function(player, last_login)
    exit_mt_gameplay.level = 0
    local name = player:get_player_name()
    if exit_mt_generation ~= nil then

        exit_mt_generation.restart()

        if exit_mt_gameplay.first_level and exit_mt_gameplay.first_level.triggers and exit_mt_gameplay.first_level.triggers[1] then
            exit_mt_gameplay.first_level.triggers[1]:remove()
        end

        if exit_mt_gameplay.mobs and exit_mt_gameplay.mobs.alarm then
            exit_mt_gameplay.mobs.alarm:remove()
        end

        exit_mt_gameplay.first_level = {
            players = {
                players = {},
                amount = 0,
            },
            players_exit = {
                players = {},
                amount = 0,
            },
            players_enter = {
                players = {},
                amount = 0,
            },
            triggers = {},
            triggers_start_pos = {},
            triggers_exit_pos = {},
            block_pos = {},
            anomaly = false,
        }
        exit_mt_gameplay.second_level = {
            triggers_pos = {},
            triggers_exit_pos = {},
            triggers_start_pos = {},
            block_pos = {},
            anomaly = false,
        }
        local data = exit_mt_generation.place_structure_first()
        if data == nil then
            return
        end
        exit_mt_gameplay.games_nodes = data.game_nodes

        exit_mt_gameplay.start_pos = exit_mt_gameplay.start_pos and exit_mt_gameplay.start_pos or data.trigger1[math.random(1, #data.trigger1)]

        local pos = exit_mt_gameplay.start_pos

        player:set_pos(pos)

        local data2 = exit_mt_generation.place_structure_second(exit_mt_gameplay.games_nodes[2])
        if data2 == nil then
            return
        end

        for i=1,#data2.trigger1 do
            core.set_node(data2.trigger1[i], {name="air"})
            exit_mt_gameplay.second_level.triggers_start_pos[i] = data2.trigger1[i]
        end

        exit_mt_gameplay.first_level.game_nodes = data.game_nodes
        exit_mt_gameplay.second_level.game_nodes = data2.game_nodes
        exit_mt_gameplay.second_level.anomaly = data2.game_nodes[3]

        exit_mt_gameplay.second_level.triggers_exit_pos = data2.trigger2
        exit_mt_gameplay.first_level.triggers_exit_pos = data.trigger2


        exit_mt_gameplay.first_level.block_pos = data.block
        exit_mt_gameplay.second_level.block_pos = data2.block


        local trigger = core.add_entity(pos+vector.new(1,1,1), "exit_mt_gameplay:trigger2")
        exit_mt_gameplay.first_level.triggers[1] = trigger

    end
    exit_mt_gameplay.players = exit_mt_gameplay.players and exit_mt_gameplay.players or {}
    exit_mt_gameplay.players[#exit_mt_gameplay.players+1] = name
    --core.chat_send_all(dump(exit_mt_gameplay.players))
end)

core.register_on_leaveplayer(function (player)
    local name = player:get_player_name()
    local players = {}
    for i=1,#exit_mt_gameplay.players do
        if name ~= exit_mt_gameplay.players[i] then
            players[i] = exit_mt_gameplay.players[i]
        end
    end

    exit_mt_gameplay.players = players
    --core.chat_send_all(dump(players))
end)