local register_node = core.register_node
local register_alias = core.register_alias


local placeholder_to_replace = {
    placeholder_01 = {"tables_chairs:planks_chair", "tables_chairs:planks_stool", "air"},
    placeholder_02 = {"tables_chairs:planks_table", "air"},
    placeholder_03 = {"exit_mt_blocks:planks", "air"},
}

local group_to_footstep = {
    concrete = {name="footstep_concrete", gain=0.5}
}

register_node('exit_mt_blocks:planks', {
    description = 'Just planks',
    tiles = { 'exit_mt_planks.png' },
    is_ground_content = true,
    groups = {wood = 1, oddly_breakable_by_hand=1},
    sounds = {
        footstep = group_to_footstep.concrete
    }
})

register_node('exit_mt_blocks:box', {
    description = 'Just box',
    tiles = { 'exit_mt_box.png' },
    is_ground_content = true,
    groups = {wood = 1, oddly_breakable_by_hand=1},
    sounds = {
        footstep = group_to_footstep.concrete
    }
})

register_node('exit_mt_blocks:placeholder_01', {
    description = 'Placeholder 1',
    tiles = { 'exit_mt_placeholder_1.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:placeholder_02', {
    description = 'Placeholder 2',
    tiles = { 'exit_mt_placeholder_2.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:placeholder_03', {
    description = 'Placeholder 3',
    tiles = { 'exit_mt_placeholder_3.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:placeholder_04', {
    description = 'Placeholder 4',
    tiles = { 'exit_mt_placeholder_4.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:trigger_01', {
    description = 'Trigger 1',
    tiles = { 'exit_mt_trigger_01.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:trigger_02', {
    description = 'Trigger 2',
    tiles = { 'exit_mt_trigger_02.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:trigger_03', {
    description = 'Trigger 3',
    tiles = { 'exit_mt_trigger_03.png' },
    paramtype2 = "facedir",
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:strange_metal', {
    description = 'Metal',
    tiles = { 'exit_mt_strange_metal.png' },
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:old_bricks_01', {
    description = 'Old bricks 1',
    tiles = { 'exit_mt_old_bricks.0.png' },
    groups = {oddly_breakable_by_hand=1, old_bricks=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:old_bricks_02', {
    description = 'Old bricks 2',
    tiles = { 'exit_mt_old_bricks.1.png'},
    groups = {oddly_breakable_by_hand=1, old_bricks=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:old_bricks_03', {
    description = 'Old bricks 3',
    tiles = { 'exit_mt_old_bricks.2.png' },
    groups = {oddly_breakable_by_hand=1, old_bricks=1},
    is_ground_content = true
})

register_node('exit_mt_blocks:old_brick_floor_01', {
    description = 'Old brick floor 1',
    tiles = { 'exit_mt_old_brick_floor.0.png' },
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true,
    sounds = {
        footstep = group_to_footstep.concrete
    }
})

register_node('exit_mt_blocks:trigger', {
    description = 'Trigger',
    tiles = { 'exit_mt_trigger.png' },
    groups = {oddly_breakable_by_hand=1},
    is_ground_content = true,
    sounds = {
        footstep = group_to_footstep.concrete
    }
})

register_node('exit_mt_blocks:water', {
    description = 'Water',
    tiles = { 'exit_mt_strange_metal.png' },
    drawtype = "liquid",
    liquidtype = "flowing",
    paramtype = "light",
    drowning = 1,
    liquid_move_physics = true,
    walkable = false,
    paramtype2 = "flowingliquid"
})


register_alias('mapgen_stone', 'exit_mt_blocks:planks')
register_alias('mapgen_water_source', 'exit_mt_blocks:planks')
register_alias('mapgen_river_water_source', 'exit_mt_blocks:planks')

dofile(core.get_modpath("exit_mt_blocks").."/light_blocks.lua")
dofile(core.get_modpath("exit_mt_blocks").."/decoration_blocks.lua")