local S = core.get_translator("whoopsy_cushion")


local colBox = {
        type = "fixed",
        fixed = {
            {-8/16, -8/16, -8/16, 8/16, 0/16, 8/16},
        },
    }
    
local camo = {
    
-- DIRT
    ["dirt"] = {
        ["texture"] = "default_dirt.png",
        ["block_name"] = "mcl_core:dirt",
        
    },
    
-- STONE
    ["stone"] = {
        ["texture"] = "default_stone.png",
        ["block_name"] = "mcl_core:stone",
        
    },
    
-- GRASS PATH
    ["grass_path"] = {
        ["texture"] = "mcl_core_grass_path_top.png",
        ["block_name"] = "mcl_core:grass_path",
        
    },
    
-- MOSS
    ["moss"] = {
        ["texture"] = "mcl_lush_caves_moss_block.png",
        ["block_name"] = "mcl_lush_caves:moss",
        
    },
    
-- BRICK BLOCK
    ["brick_block"] = {
        ["texture"] = "default_brick.png",
        ["block_name"] = "mcl_core:brick_block",
        
    },
    
-- GOLD BLOCK
    ["gold_block"] = {
        ["texture"] = "default_gold_block.png",
        ["block_name"] = "mcl_core:goldblock",
        
    },
    
-- COBBLE STONE
    ["cobble"] = {
        ["texture"] = "default_cobble.png",
        ["block_name"] = "mcl_core:cobble",
        
    },
    
-- SLIME BLOCK
    ["slime_block"] = {
        ["texture"] = "mcl_core_slime.png",
        ["block_name"] = "mcl_core:slimeblock",
        
    },

-- OBSIDIAN
    ["obsidian"] = {
        ["texture"] = "default_obsidian.png",
        ["block_name"] = "mcl_core:obsidian",
        
    },
    
-- DIAMOND
    ["diamond"] = {
        ["texture"] = "default_diamond_block.png",
        ["block_name"] = "mcl_core:diamondblock",
        
    },
    
-- MYCELIUM
    ["mycelium"] = {
        ["texture"] = "mcl_core_mycelium_top.png",
        ["block_name"] = "mcl_core:mycelium",
        
    },
    
-- PODZOL
    ["podzol"] = {
        ["texture"] = "mcl_core_dirt_podzol_top.png",
        ["block_name"] = "mcl_core:podzol",
        
    },
    
-- OAK WOOD PLANKS
    ["oak_planks"] = {
        ["texture"] = "default_wood.png",
        ["block_name"] = "mcl_trees:wood_oak",
        
    },

}

for texture, value in pairs(camo) do

 
 
    
    core.register_node("whoopsy_cushion:camo_whoopee_cushion_"..texture, {
        description = S("Whoopee Cushion Camouflaged with "..whoopsy_cushion.capitalize(texture)),
        _tt_help = S("Makes the sound of flatulence when you step on it"),
        --_doc_items_longdesc = S(""),
        --_doc_items_usagehelp = S(""),
        groups = {
            dig_immediate=2,
            bouncy=20, fall_damage_add_percent=-100,
            falling_node=1,
            flammable=1, fire_encouragement=10, fire_flammability=30,
            enderman_takable=1,
            whoopsy_tex_col=1,
        },
        wield_image = "("..value["texture"].."^[mask:wc_main_leather_wield_mask.png)^[overlay:wc_main_leather_wield_desat.png",
        wield_scale = { x=1, y=1, z=0.5 },
        tiles = {value["texture"]},
        inventory_image = "("..value["texture"].."^[mask:wc_main_leather_mask.png)^[overlay:wc_main_leather_desat.png",
        inventory_overlay = "wc_main_leather_smoke.png",
        walkable = true,
        drawtype = "mesh",
        mesh = "wc_model_st.obj",
        paramtype = "light",
        collision_box = colBox,
        selection_box = colBox,
        tool_capabilities = {
            damage_groups = {fleshy = 0},
        },
        on_punch = function(pos, node, puncher, pointed_thing)
            core.sound_play ("wc_flatulence_sound")
        end,
        sound = {
            punch_use = "wc_punch_sound",
            punch_use_air = "wc_flatulence_sound",
        },
        sounds = {
            footstep = {
                name = "wc_flatulence_sound",
                gain = 0.4
            },
            place = {
                name = "wc_place_sound",
                gain = 0.2
            
            },
            fall = {
                name = "wc_falling_sound",
                gain = 0.1
            
            },
            dug = {
                name = "wc_dug_sound",
                gain = 0.2
            
            },
        },
    });


    core.register_craft({
            type = "shapeless",
            output = "whoopsy_cushion:camo_whoopee_cushion_"..texture,
            recipe = {
                "group:whoopsy_tex_col",
                value["block_name"],
            }
    });

end