local C = core.colorize
local S = core.get_translator("whoopsy_cushion")


local colBox = {
        type = "fixed",
        fixed = {
            {-8/16, -8/16, -8/16, 8/16, 0/16, 8/16},
        },
    }

local colors = {

-- WHITE
    ["white"] = {
        ["color"] = "#d0d6d7",
        ["item_color"] = "mcl_dyes:white",
    },
    
-- LIGHT GREY
    ["silver"] = {
        ["color"] = "#818177",
        ["item_color"] = "mcl_dyes:silver",
    },
    
-- GREY
    ["grey"] = {
        ["color"] = "#383c40",
        ["item_color"] = "mcl_dyes:grey",
    },
    
-- BLACK
    ["black"] = {
        ["color"] = "#0F0F0F",
        ["item_color"] = "mcl_dyes:black",
    },

-- BLUE
    ["blue"] = {
        ["color"] = "#2e3094",
        ["item_color"] = "mcl_dyes:blue",
        
    },
    
-- LIGHT BLUE
    ["light_blue"] = {
        ["color"] = "#258ec9",
        ["item_color"] = "mcl_dyes:light_blue",
        
    },
    
-- CYAN
    ["cyan"] = {
        ["color"] = "#168C7C",
        ["item_color"] = "mcl_dyes:cyan",
    },
    
-- PURPLE
    ["purple"] = {
        ["color"] = "#6821a0",
        ["item_color"] = "mcl_dyes:purple",
    },
    
-- GREEN
    ["green"] = {
        ["color"] = "#4b5e25",
        ["item_color"] = "mcl_dyes:green",
    },
    
-- LIME
    ["lime"] = {
        ["color"] = "#60ac19",
        ["item_color"] = "mcl_dyes:lime",
    },

-- YELLOW
    ["yellow"] = {
        ["color"] = "#f1b216",
        ["item_color"] = "mcl_dyes:yellow",
    },
    
-- BROWN
    ["brown"] = {
        ["color"] = "#633d20",
        ["item_color"] = "mcl_dyes:brown",
    },
    
-- ORANGE
    ["orange"] = {
        ["color"] = "#e26501",
        ["item_color"] = "mcl_dyes:orange",
    },
    
-- RED
    ["red"] = {
        ["color"] = "#912222",
        ["item_color"] = "mcl_dyes:red",
    },
    
-- MAGENTA
    ["magenta"] = {
        ["color"] = "#ab31a2",
        ["item_color"] = "mcl_dyes:magenta",
    },
    
-- PINK
    ["pink"] = {
        ["color"] = "#d56791",
        ["item_color"] = "mcl_dyes:pink",
    },
}



for color, value in pairs(colors) do
    core.register_node("whoopsy_cushion:whoopee_cushion_"..color, {
        description = S(whoopsy_cushion.capitalize(color).." Whoopee Cushion"),
        _tt_help = S("Makes the sound of flatulence when you step on it"),
        --_doc_items_longdesc = S(""),
        --_doc_items_usagehelp = S(""),
        groups = {
            dig_immediate=2,
            bouncy=20, fall_damage_add_percent=-100,
            falling_node=1,
            flammable=1, fire_encouragement=10, fire_flammability=30,
            enderman_takable=1,
            whoopsy_tex_col=1,
        },
        wield_image = "wc_main_leather_wield_desat.png^[multiply:"..value["color"],
        wield_scale = { x=1, y=1, z=0.5 },
        tiles = {"wc_texture_leather_desat.png^[multiply:"..value["color"]},
        inventory_image = "wc_main_leather_desat.png^[multiply:"..value["color"],
        inventory_overlay = "wc_main_leather_smoke.png",
        walkable = true,
        drawtype = "mesh",
        mesh = "wc_model_st.obj",
        paramtype = "light",
        collision_box = colBox,
        selection_box = colBox,
        tool_capabilities = {
            damage_groups = {fleshy = 0},
        },
        on_punch = function(pos, node, puncher, pointed_thing)
            core.sound_play ("wc_flatulence_sound")
        end,
        sound = {
        punch_use = "wc_punch_sound",
        punch_use_air = "wc_flatulence_sound",
        
--[[ 
        =====================================
        This was supposed to be a script of washing, 
        but it doesn't work, and I don't know how to make it work yet. 
        So… probably in the next updates… 
        =====================================

        on_place = function(itemstack, placer, pointed_thing)
            if mcl_util.check_position_protection(pointed_thing.under, placer) then return itemstack end
            if core.get_item_group(core.get_node(pointed_thing.under).name, "cauldron_water") <= 0 then return end
            
           if mcl_cauldrons.add_level(pointed_thing.under, -1) then
                local outcome = whoopsy_cushion:whoopee_cushion(itemstack)
                if outcome then
                    core.sound_play("mcl_potions_bottle_pour", {pos=pointed_thing.under, gain=0.5, max_hear_range=16}, true)
                    return outcome
                end
            end
        
        end,
--]]
        
        },
        sounds = {
            footstep = {
                name = "wc_flatulence_sound",
                gain = 0.4
            },
            place = {
                name = "wc_place_sound",
                gain = 0.2
            
            },
            fall = {
                name = "wc_falling_sound",
                gain = 0.1
            
            },
            dug = {
                name = "wc_dug_sound",
                gain = 0.2
            
            },
        },
    });


    core.register_craft({
        type = "shapeless",
        output = "whoopsy_cushion:whoopee_cushion_"..color,
        recipe = {
            "group:whoopsy_tex_col",
            value["item_color"],
        }
    });

end
