local S = core.get_translator("whoopsy_cushion")



--collision/selection box size
local colBox = {
        type = "fixed",
        fixed = {
            {-8/16, -8/16, -8/16, 8/16, 0/16, 8/16},
        },
    }



core.register_node("whoopsy_cushion:whoopee_cushion", {
    description = S("Whoopee Cushion"),
    _tt_help = S("Makes the sound of flatulence when you step on it"),
    --_doc_items_longdesc = S(""),
    --_doc_items_usagehelp = S(""),
    groups = {
        dig_immediate=2,
        bouncy=20, fall_damage_add_percent=-100,
        falling_node=1,
        flammable=1, fire_encouragement=10, fire_flammability=30,
        enderman_takable=1,
        whoopsy_tex_col=1,
    },
    wield_image = "wc_main_leather_wield.png",
    wield_scale = { x=1, y=1, z=0.5 },
    tiles = {"wc_texture_leather.png"},
    inventory_image = "wc_main_leather.png",
    inventory_overlay = "wc_main_leather_smoke.png",
    walkable = true,
    drawtype = "mesh",
    mesh = "wc_model_st.obj",
    paramtype = "light",
    collision_box = colBox,
    selection_box = colBox,
    tool_capabilities = {
        damage_groups = {fleshy = 0},
    },
    on_punch = function(pos, node, puncher, pointed_thing)
        core.sound_play ("wc_flatulence_sound")
    end,
    sound = {
        punch_use = "wc_punch_sound",
        punch_use_air = "wc_flatulence_sound",
    },
    sounds = {
        footstep = {
            name = "wc_flatulence_sound",
            gain = 0.4
        },
        place = {
            name = "wc_place_sound",
            gain = 0.2
        
        },
        fall = {
            name = "wc_falling_sound",
            gain = 0.1
        
        },
        dug = {
            name = "wc_dug_sound",
            gain = 0.2
        
        },
    },
    
});




core.register_craft({
    --type = "shaped",
    output = "whoopsy_cushion:whoopee_cushion",
    recipe = {
        {"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
        {"mcl_mobitems:leather", "mcl_mobitems:leather", "mcl_mobitems:leather"},
    }
});

awards.register_achievement("whoopsy_cushion:whoopee_cushion", {
    title = S("Suspicious Noise..."),
    description = S("Craft the Whoopee Cushion."),
    icon = "wc_main_leather.png",
    trigger = {
        type = "craft",
        item = "whoopsy_cushion:whoopee_cushion",
        target = 1
    },
    type = "Advancement",
    group = "Overworld",
})
