mathplot.gui.screens = mathplot.gui.screens or {}

mathplot.gui.screens["examples"] = {
    initialize = function(playername, identifier, context)
    end,
    get_formspec = function(playername, identifier, context)
        local formspec = "size[12.25,9.75]"
        .. "label[0,0;Examples]"
        .. "container[0,1]"
        .. "label[0,0;Implicit Plot]"
        .. "button_exit[0,0.5;3,1;btn_hemisphere;Hemisphere]"
        .. "button_exit[3,0.5;3,1;btn_solid_hemisphere;Solid Hemisphere]"
        .. "button_exit[6,0.5;3,1;btn_cylinder_with_tunnel;Cylinder w/ Tunnel]"
        .. "button_exit[9,0.5;3,1;btn_implicit_cone;Cone]"
        .. "container_end[]"
        .. "container[0,3]"
        .. "label[0,0;Parametric Curve]"
        .. "button_exit[0,0.5;3,1;btn_onevar_ftn_graph;Graph of Function]"
        .. "button_exit[3,0.5;3,1;btn_helix;Helix]"
        .. "button_exit[6,0.5;3,1;btn_coil;Coil]"
        .. "button_exit[9,0.5;3,1;btn_trefoil_knot;Trefoil Knot]"
        .. "container_end[]"
        .. "container[0,5]"
        .. "label[0,0;Parametric Surface]"
        .. "button_exit[0,0.5;3,1;btn_twovar_ftn_graph;Graph of Function]"
        .. "button_exit[3,0.5;3,1;btn_parametric_torus;Torus]"
        .. "button_exit[6,0.5;3,1;btn_surface_of_revolution;Surface of Revolution]"
        .. "tooltip[btn_surface_of_revolution;The surface generated by revolving the graph of y = 5x/6 - x^3/200 about the x-axis, then translated vertically in the z-direction]"
        .. "button_exit[9,0.5;3,1;btn_klein_bottle;Klein Bottle]"
        .. "container_end[]"
        .. "container[0,7]"
        .. "label[0,0;Parametric Solid]"
        .. string.format("button_exit[0,0.5;3,1;btn_thick_twovar_ftn_graph;%s]", minetest.formspec_escape("'Thick' Graph"))
        .. "tooltip[btn_thick_twovar_ftn_graph;The graph of a two-variable function, extruded in the z-direction]"
        .. "button_exit[3,0.5;3,1;btn_solid_of_revolution;Solid of Revolution]"
        .. "tooltip[btn_solid_of_revolution;The solid generated by revolving the region between the graphs of x = 3z/10 and x = 5+(z/10)^2 about the z-axis]"
        .. "container_end[]"
        .. "button_exit[0,9;2,1;btn_exit;Exit]"
        return formspec
    end,
    on_receive_fields = function(playername, identifier, fields, context)
        for name, _ in pairs(fields) do
            if string.match(name, "^btn_") then
                local exampleName = string.gsub(name, "^btn_", "")
                local exampleExists = mathplot.examples[exampleName] ~= nil
                if exampleExists then
                    mathplot.examples[exampleName](playername, context.node_pos)
                    break
                end
            end
        end
    end
}

