mathplot.gui.screens = mathplot.gui.screens or {}

local S = mathplot.get_translator
local E = minetest.formspec_escape

mathplot.gui.screens["validation_errors"] = {
    initialize = function(playername, identifier, context)
    end,
    get_formspec = function(playername, identifier, context)
        local errorsStr = E(table.concat(context.errormsgs, "\n"))
        local formspec = "size[5.5,6]"
        .. string.format("label[0,0;%s]", S("Errors:"))
        .. "textarea[0.25,0.5;5.75,5.5;;;" .. errorsStr .. "]"
        .. string.format("button_exit[0,5.5;2,1;btn_ok;%s]", S("OK"))
        return formspec
    end,
    on_receive_fields = function(playername, identifier, fields, context)
        --Avoid events like clicking a textlist to trigger the form being done.
        local done = fields.quit == "true"
        return done
    end
}
