ediblestuff = {}
-- How much does an arbirary item satiate when equipped?
-- This is only needed because calling on_use is much more expensive and might have side effects
ediblestuff.satiates = {}
ediblestuff.make_thing_edible = function(item,amount)
	minetest.override_item(item, {
		on_use = minetest.item_eat(amount),
	})
	ediblestuff.satiates[item] = amount
	if minetest.get_modpath("hunger_ng") ~= nil then
		hunger_ng.add_hunger_data(item, {
			satiates = amount,
		})
	end
end
ediblestuff.make_things_edible = function(mod,name,scale,items)
	for typ,amount in pairs(items) do
		ediblestuff.make_thing_edible(mod..":"..typ.."_"..name,scale*amount)
	end
end
if minetest.get_modpath("stamina") then
	if stamina.settings ~= nil then
		-- For minetest-mods/stamina
		ediblestuff.get_max_hunger = function ()
			return stamina.settings.visual_max
		end
	else
	    -- works for TenPlus1 and sofar
		ediblestuff.get_max_hunger = function ()
			return STAMINA_VISUAL_MAX
		end
	end
	ediblestuff.get_hunger = function (player)
		local meta = player:get_meta()
		local amount = meta:get_string("stamina:level")
		if not amount then return end
		return tonumber(amount)
	end
	ediblestuff.alter_hunger = stamina.change
elseif minetest.get_modpath("hbhunger") then
	ediblestuff.get_max_hunger = function ()
		return hbhunger.SAT_MAX
	end
	ediblestuff.get_hunger = function (player)
		return hbhunger.get_hunger_raw(player)
	end
	ediblestuff.alter_hunger = function (player, amount)
		local name = player:get_player_name()
		hbhunger.hunger[name] = hbhunger.hunger[name] + amount
		hbhunger.set_hunger_raw(player)
	end
elseif minetest.get_modpath("hunger_ng") then
	ediblestuff.get_max_hunger = function (player)
		local info = hunger_ng.get_hunger_information(player:get_player_name())
		if info.invalid then return end
		return info.maximum.hunger
	end
	ediblestuff.get_hunger = function (player)
		local info = hunger_ng.get_hunger_information(player:get_player_name())
		if info.invalid then return end
		return info.hunger.exact
	end
	ediblestuff.alter_hunger = function (player, amount)
		hunger_ng.alter_hunger(player:get_player_name(),amount)
	end
else
	-- No known hunger mod. Use hp instead.
	minetest.log("info","ediblestuff: no known hunger mod. using hp as hunger instead")
	ediblestuff.get_max_hunger = function (player)
		return player:get_properties().hp_max
	end
	ediblestuff.get_hunger = function (player)
		return player:get_hp()
	end
	ediblestuff.alter_hunger = function (player, amount)
		player:set_hp(player:get_hp()+amount)
	end
end
ediblestuff.equipped = {}
ediblestuff.edible_while_wearing = {}
if minetest.get_modpath("3d_armor") ~= nil then
	-- check if they have the armor equipped.
	local function armor_search(elms)
		for _,elm in pairs(elms) do
			if ediblestuff.edible_while_wearing[elm] then
				return true
			end
		end
		return false
	end
	local function delayed_armor_check(pname)
		return function ()
			local player=minetest.get_player_by_name(pname)
			-- this can fail inside register_on_joinplayer.
			local elms=armor:get_weared_armor_elements(player)
			if elms == nil then
				-- If it does fail, wait another second (it's possible to get into an infinite loop here...)
				minetest.log("info", "ediblestuff: armor check was delayed...")
				minetest.after(1, delayed_armor_check(pname))
				return
			end
			if armor_search(elms) then
				ediblestuff.equipped[pname] = true
			else
				ediblestuff.equipped[pname] = nil
			end
		end
	end
	local function armor_check_event(player)
		-- We don't know if the reference to player is still valid after the delay(s). Just pass the name.
		minetest.after(0, delayed_armor_check(player:get_player_name()))
	end
	minetest.register_on_joinplayer(armor_check_event)
	armor:register_on_equip(armor_check_event)
	armor:register_on_unequip(armor_check_event)
	armor:register_on_destroy(armor_check_event)
	minetest.register_globalstep(function()
		-- Instead of iterating over every player, only iterate over players we know have ediblestuff equipped
		for pname,_ in pairs(ediblestuff.equipped) do
			local player=minetest.get_player_by_name(pname)
			local n, armor_inv = armor:get_valid_player(player,"[chocolatestuff register_globalstep]")
			if n then
				local hunger_max = ediblestuff.get_max_hunger(player)
				local hunger_ratio = (hunger_max - ediblestuff.get_hunger(player))/hunger_max
				if hunger_ratio >= .15 then -- TODO make this a setting
					local inv_list = armor_inv:get_list("armor")
					local list = {}
					for i,slot in ipairs(inv_list) do
						if slot:get_count() > 0 then
							list[#list+1] = {slot, i}
						end
					end
					local victim_armor_tuple = list[math.random(#list)]
					local victim_armor, index = victim_armor_tuple[1], victim_armor_tuple[2]
					local armor_max = 65535 -- largest possible tool durability
					local durability_ratio = (armor_max - victim_armor:get_wear())/armor_max
					local item_satiates = ediblestuff.satiates[victim_armor:get_name()]
					if not item_satiates then
						item_satiates = hunger_max
					end
					local possible_satiation = math.min(hunger_ratio,durability_ratio)
					ediblestuff.alter_hunger(player,possible_satiation*item_satiates)
					armor:damage(player,index,victim_armor,possible_satiation*armor_max)
					minetest.chat_send_player(pname,"You ate "..math.ceil(possible_satiation*100).."% of your equipped "..victim_armor:get_short_description())
					if hunger_ratio >= durability_ratio then
						local old_armor=ItemStack(victim_armor)
						victim_armor:take_item()
						armor:set_inventory_stack(player,index,victim_armor)
						armor:run_callbacks("on_unequip",player,index,old_armor)
						armor:run_callbacks("on_destroy",player,index,old_armor)
						armor:set_player_armor(player)
					end
				end
			else
				ediblestuff.equipped[pname]=nil
			end
		end
	end)
end
