-- Commande pour diffuser un message à tout le serveur
minetest.register_chatcommand("announce", {
    params = "<message>",
    description = "Announce a message to the entire server",
    privs = {privs = true},
    func = function(player_name, param)
        if not param or param == "" then
            return false, "Usage: /announce <message>"
        end

        -- Récupérer tous les joueurs connectés
        local players = minetest.get_connected_players()

        -- Récupérer le message à diffuser
        local message = minetest.strip_colors(param)

        -- Diffuser le message à tous les joueurs
        for _, player in pairs(players) do
            minetest.chat_send_player(player:get_player_name(), "[Announcement] " .. message)
        end

        return true, "Announcement sent to all players."
    end,
})
