-- Commande pour supprimer tous les blocs dans une région
minetest.register_chatcommand("cut", {
    params = "<x1> <y1> <z1> <x2> <y2> <z2>",
    description = "Delete all blocks in a region",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 6 then
            return false, "Usage: /cut <x1> <y1> <z1> <x2> <y2> <z2>"
        end

        local x1, y1, z1, x2, y2, z2 = tonumber(args[1]), tonumber(args[2]), tonumber(args[3]), tonumber(args[4]), tonumber(args[5]), tonumber(args[6])

        if not x1 or not y1 or not z1 or not x2 or not y2 or not z2 then
            return false, "Invalid coordinates. Coordinates must be numeric."
        end

        -- Assurez-vous que x1 <= x2, y1 <= y2, et z1 <= z2
        x1, x2 = math.min(x1, x2), math.max(x1, x2)
        y1, y2 = math.min(y1, y2), math.max(y1, y2)
        z1, z2 = math.min(z1, z2), math.max(z1, z2)

        -- Supprimez les blocs dans la région en les remplaçant par de l'air
        local count_deleted = 0
        for x = x1, x2 do
            for y = y1, y2 do
                for z = z1, z2 do
                    local pos = {x = x, y = y, z = z}
                    minetest.set_node(pos, {name = "air"})
                    count_deleted = count_deleted + 1
                end
            end
        end

        if count_deleted > 0 then
            return true, "Deleted " .. count_deleted .. " blocks in the region."
        else
            return true, "No blocks found in the region."
        end
    end,
})
