-- Commande pour remplir une région avec un bloc choisi
minetest.register_chatcommand("set", {
    params = "<node_name> <x1> <y1> <z1> <x2> <y2> <z2>",
    description = "Fill a region with the specified node",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 7 then
            return false, "Usage: /set <node_name> <x1> <y1> <z1> <x2> <y2> <z2>"
        end

        local node_name = args[1]
        local x1, y1, z1, x2, y2, z2 = tonumber(args[2]), tonumber(args[3]), tonumber(args[4]), tonumber(args[5]), tonumber(args[6]), tonumber(args[7])

        if not x1 or not y1 or not z1 or not x2 or not y2 or not z2 then
            return false, "Invalid coordinates. Coordinates must be numeric."
        end

        -- Assurez-vous que x1 <= x2, y1 <= y2, et z1 <= z2
        x1, x2 = math.min(x1, x2), math.max(x1, x2)
        y1, y2 = math.min(y1, y2), math.max(y1, y2)
        z1, z2 = math.min(z1, z2), math.max(z1, z2)

        -- Vérifier que le bloc spécifié existe
        if not minetest.registered_nodes[node_name] then
            return false, "Invalid node name. Node does not exist."
        end

        -- Remplir la région avec le bloc spécifié
        for x = x1, x2 do
            for y = y1, y2 do
                for z = z1, z2 do
                    local pos = {x = x, y = y, z = z}
                    minetest.set_node(pos, {name = node_name})
                end
            end
        end

        return true, "Region filled with " .. node_name .. "."
    end,
})
