-- Table pour stocker l'état d'invincibilité des joueurs
local invincible_players = {}
local regenerating_players = {}

-- Vitesse de régénération (en secondes)
local regeneration_speed = 0.00000000001  -- Vous pouvez ajuster la vitesse au besoin

-- Fonction pour gérer la régénération du joueur
local function regenerate_player(player_name)
    local player = minetest.get_player_by_name(player_name)
    if player and regenerating_players[player_name] then
        local hp = player:get_hp()
        if hp < 20 then
            player:set_hp(hp + 10)  -- Augmentez le montant de régénération si nécessaire
        end
        minetest.after(regeneration_speed, regenerate_player, player_name)
    end
end

-- Commande pour activer ou désactiver l'invincibilité et la régénération
minetest.register_chatcommand("invincible", {
    params = "<on|off>",
    description = "Toggle admin invincibility and regeneration",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        if param == "on" then
            -- Activer l'invincibilité pour le joueur
            invincible_players[player_name] = true
            -- Activer la régénération pour le joueur
            regenerating_players[player_name] = true
            regenerate_player(player_name)
            return true, "You are now invincible and regenerating."
        elseif param == "off" then
            -- Désactiver l'invincibilité pour le joueur
            invincible_players[player_name] = nil
            -- Désactiver la régénération pour le joueur
            regenerating_players[player_name] = nil
            return true, "Invincibility and regeneration turned off."
        else
            return false, "Invalid parameter. Use /invincible on or /invincible off."
        end
    end,
})

