-- Table pour stocker l'état de disparition des joueurs
local vanish_players = {}

-- Commande pour activer ou désactiver la disparition
minetest.register_chatcommand("vanish", {
    params = "<on|off>",
    description = "Toggle admin vanish",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        if param == "on" then
            -- Rendre le joueur invisible
            player:set_properties({is_visible = false})
            vanish_players[player_name] = true
            return true, "You are now vanished."
        elseif param == "off" then
            -- Rendre le joueur visible à nouveau
            player:set_properties({is_visible = true})
            vanish_players[player_name] = nil
            return true, "Vanish turned off."
        else
            return false, "Invalid parameter. Use /vanish on or /vanish off."
        end
    end,
})
