-- Commande pour changer le mode de jeu des joueurs
minetest.register_chatcommand("gamemode", {
    params = "<player> <mode>",
    description = "Change a player's game mode §!warning : experimental!§",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 2 then
            return false, "Usage: /gamemode <player> <mode>"
        end

        local target_name = args[1]
        local target_player = minetest.get_player_by_name(target_name)
        if not target_player then
            return false, "Player not found."
        end

        local mode = args[2]

        -- Vérifier si le mode est valide (creative ou survival)
        if mode == "creative" or mode == "survival" then
            target_player:set_physics_override(1, 1, 1)
            target_player:set_inventory_formspec("")
            target_player:set_armor_groups({immortal = 0})

            if mode == "creative" then
                target_player:set_physics_override(0, 0, 0)
                target_player:set_inventory_formspec("size[8,7.5]"..
                "button[1,0;2,0.5;creative;Survival]"..
                "list[current_player;main;0,3.5;8,4;]"..
                "list[current_player;craft;0,0.5;2,2;]")
                target_player:set_armor_groups({immortal = 1})
            end

            return true, target_name .. " is now in " .. mode .. " mode."
        else
            return false, "Invalid mode. Use 'creative' or 'survival'."
        end
    end,
})
