-- Vérifier si un joueur est administrateur
local function is_admin(player_name)
    return minetest.check_player_privs(player_name, {privs = true})
end

-- Créer un dossier "build" dans le dossier des mondes lors du chargement du mod
local worldpath = minetest.get_worldpath()
local buildpath = worldpath .. "/build"

minetest.mkdir(buildpath)  -- Cette ligne crée le dossier "build" s'il n'existe pas déjà

-- Charger les fichiers de commandes
dofile(minetest.get_modpath("test_edit").."/invincible.lua")
dofile(minetest.get_modpath("test_edit").."/vanish.lua")
dofile(minetest.get_modpath("test_edit").."/tp.lua")
dofile(minetest.get_modpath("test_edit").."/spawn.lua")
dofile(minetest.get_modpath("test_edit").."/gamemode.lua")
dofile(minetest.get_modpath("test_edit").."/tprandom.lua")
dofile(minetest.get_modpath("test_edit").."/announce.lua")
dofile(minetest.get_modpath("test_edit").."/tpr.lua")
dofile(minetest.get_modpath("test_edit").."/setblock.lua")
dofile(minetest.get_modpath("test_edit").."/copy.lua")
dofile(minetest.get_modpath("test_edit").."/paste.lua")
dofile(minetest.get_modpath("test_edit").."/set.lua")
dofile(minetest.get_modpath("test_edit").."/replace.lua")
dofile(minetest.get_modpath("test_edit").."/replace2.lua")
dofile(minetest.get_modpath("test_edit").."/cut.lua")

minetest.register_tool("test_edit:select_stick", {
    description = "Sélection Stick",
    inventory_image = "select_stick.png",
    on_use = function(itemstack, user, pointed_thing)
        local player_name = user:get_player_name()
        local player_meta = minetest.get_meta(user)
        local is_sneaking = user:get_player_control().sneak

        if is_sneaking then
            -- Si le joueur est en train de s'accroupir (Shift), utilisez le clic droit pour la deuxième coordonnée
            if pointed_thing.type == "node" then
                local pos = pointed_thing.under
                player_meta:set_string("selection_pos2", minetest.pos_to_string(pos))
                minetest.chat_send_player(player_name, "Deuxième position sélectionnée: " .. minetest.pos_to_string(pos))
            end
        else
            -- Si le joueur n'est pas en train de s'accroupir, utilisez le clic gauche pour la première coordonnée
            if pointed_thing.type == "node" then
                local pos = pointed_thing.under
                player_meta:set_string("selection_pos1", minetest.pos_to_string(pos))
                minetest.chat_send_player(player_name, "Première position sélectionnée: " .. minetest.pos_to_string(pos))
            end
        end

        return itemstack
    end,
})
