-- Commande pour remplacer des blocs dans une région
minetest.register_chatcommand("replace", {
    params = "<node_name_old> <node_name_new> <x1> <y1> <z1> <x2> <y2> <z2>",
    description = "Replace blocks in a region with the specified node",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 8 then
            return false, "Usage: /replace <node_name_old> <node_name_new> <x1> <y1> <z1> <x2> <y2> <z2>"
        end

        local node_name_old = args[1]
        local node_name_new = args[2]
        local x1, y1, z1, x2, y2, z2 = tonumber(args[3]), tonumber(args[4]), tonumber(args[5]), tonumber(args[6]), tonumber(args[7]), tonumber(args[8])

        if not x1 or not y1 or not z1 or not x2 or not y2 or not z2 then
            return false, "Invalid coordinates. Coordinates must be numeric."
        end

        -- Assurez-vous que x1 <= x2, y1 <= y2, et z1 <= z2
        x1, x2 = math.min(x1, x2), math.max(x1, x2)
        y1, y2 = math.min(y1, y2), math.max(y1, y2)
        z1, z2 = math.min(z1, z2), math.max(z1, z2)

        -- Remplacer les blocs dans la région
        local count_replaced = 0
        for x = x1, x2 do
            for y = y1, y2 do
                for z = z1, z2 do
                    local pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(pos)

                    if node_name_old == "#solid" then
                        if minetest.registered_nodes[node.name] and minetest.registered_nodes[node.name].walkable then
                            minetest.set_node(pos, {name = node_name_new})
                            count_replaced = count_replaced + 1
                        end
                    elseif node_name_old == "#air" then
                        if node.name == "air" then
                            minetest.set_node(pos, {name = node_name_new})
                            count_replaced = count_replaced + 1
                        end
                    elseif node.name == node_name_old then
                        minetest.set_node(pos, {name = node_name_new})
                        count_replaced = count_replaced + 1
                    end
                end
            end
        end

        if count_replaced > 0 then
            return true, "Replaced " .. count_replaced .. " blocks in the region."
        else
            return true, "No blocks matching the criteria found in the region."
        end
    end,
})
