-- Commande pour ajouter un bloc à la position du joueur
minetest.register_chatcommand("setblock", {
    params = "<node>",
    description = "Place a block at your position",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 1 then
            return false, "Usage: /setblock <node>"
        end

        local node_name = args[1]

        -- Vérifier si le nœud est valide
        if not minetest.registered_nodes[node_name] then
            return false, "Invalid node name."
        end

        -- Récupérer la position du joueur qui exécute la commande
        local pos = player:get_pos()

        -- Placer le nœud à la position du joueur
        minetest.set_node(pos, {name = node_name})

        return true, "Placed " .. node_name .. " at your position."
    end,
})
