-- Commande pour téléporter un joueur au hasard sur votre position
minetest.register_chatcommand("tpr", {
    params = "",
    description = "Teleport a random player to your position",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        -- Récupérer la liste des joueurs connectés
        local players = minetest.get_connected_players()

        if #players == 1 then
            return false, "There are no other players to teleport."
        end

        -- Sélectionner un joueur au hasard (à l'exception du joueur qui exécute la commande)
        local random_index = math.random(1, #players)
        local random_player = players[random_index]

        -- Récupérer la position du joueur qui exécute la commande
        local pos = player:get_pos()

        -- Téléporter le joueur sélectionné sur la position du joueur qui exécute la commande
        random_player:set_pos(pos)

        return true, "Teleported a random player to your position."
    end,
})
