-- Commande pour copier une région et la stocker dans un fichier JSON
minetest.register_chatcommand("copy", {
    params = "<filename> <x1> <y1> <z1> <x2> <y2> <z2>",
    description = "Copy a region and save it to a JSON file",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 7 then
            return false, "Usage: /copy <filename> <x1> <y1> <z1> <x2> <y2> <z2>"
        end

        local filename = args[1]
        local x1, y1, z1, x2, y2, z2 = tonumber(args[2]), tonumber(args[3]), tonumber(args[4]), tonumber(args[5]), tonumber(args[6]), tonumber(args[7])

        if not x1 or not y1 or not z1 or not x2 or not y2 or not z2 then
            return false, "Invalid coordinates. Coordinates must be numeric."
        end

        -- Assurez-vous que x1 <= x2, y1 <= y2, et z1 <= z2
        x1, x2 = math.min(x1, x2), math.max(x1, x2)
        y1, y2 = math.min(y1, y2), math.max(y1, y2)
        z1, z2 = math.min(z1, z2), math.max(z1, z2)

        -- Vérifier si le fichier existe dans le dossier "build" du monde
        local world_path = minetest.get_worldpath()
        local file_path = world_path .. "/build/" .. filename .. ".json"
        local file = io.open(file_path, "w")

        if not file then
            return false, "Failed to create or open file '" .. filename .. ".json' for writing."
        end

        -- Capturez la structure des blocs dans une table Lua
        local blocks = {}
        for x = x1, x2 do
            for y = y1, y2 do
                for z = z1, z2 do
                    local pos = {x = x, y = y, z = z}
                    local node = minetest.get_node(pos)
                    table.insert(blocks, {
                        pos = {x = x - x1, y = y - y1, z = z - z1},
                        name = node.name,
                        param1 = node.param1,
                        param2 = node.param2,
                    })
                end
            end
        end

        -- Convertissez la table Lua en JSON et enregistrez-la dans le fichier
        local json_data = minetest.write_json({
            blocks = blocks,
        }, true)
        file:write(json_data)
        file:close()

        return true, "Region copied and saved to '" .. filename .. ".json'."
    end,
})
