-- Commande pour coller la région copiée à une nouvelle position
minetest.register_chatcommand("paste", {
    params = "<filename> <x> <y> <z>",
    description = "Paste a copied region from a file to a new position",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args < 4 then
            return false, "Usage: /paste <filename> <x> <y> <z>"
        end

        local filename = args[1]
        local x, y, z = tonumber(args[2]), tonumber(args[3]), tonumber(args[4])

        if not x or not y or not z then
            return false, "Invalid coordinates. Coordinates must be numeric."
        end

        -- Vérifier si le fichier existe dans le dossier "build" du monde
        local world_path = minetest.get_worldpath()
        local file_path = world_path .. "/build/" .. filename .. ".json"
        local file = io.open(file_path, "r")

        if not file then
            return false, "File '" .. filename .. ".json' not found or invalid."
        end

        -- Lire les données de la région copiée depuis le fichier
        local region_data = minetest.parse_json(file:read("*all"))
        file:close()

        -- Placer les blocs en utilisant minetest.set_node
        for _, block_data in ipairs(region_data.blocks) do
            local pos = vector.add({x = x, y = y, z = z}, block_data.pos)
            minetest.set_node(pos, {name = block_data.name, param1 = block_data.param1, param2 = block_data.param2})
        end

        return true, "Region pasted from '" .. filename .. ".json' to a new position."
    end,
})


