-- Commande pour raccourcir /spawnentity en /spawn
minetest.register_chatcommand("spawn", {
    params = "<entity>",
    description = "Spawn an entity",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        if param == "" then
            return false, "Usage: /spawn <entity>"
        end

        local entity_name = param
        local player_pos = player:get_pos()

        -- Vérifier que l'entité existe
        if minetest.registered_entities[entity_name] then
            -- Créer l'entité à la position du joueur
            minetest.add_entity(player_pos, entity_name)
            return true, "Spawned entity: " .. entity_name
        else
            return false, "Entity not found."
        end
    end,
})
