-- Enregistrez l'outil de sélection
minetest.register_tool("votre_mod:select_stick", {
    description = "Sélection Stick",
    inventory_image = "select_stick.png", -- Assurez-vous d'avoir la bonne texture
    on_use = function(itemstack, user, pointed_thing)
        -- Vérifiez si l'utilisateur pointe sur un bloc
        if pointed_thing.type == "node" then
            local pos = pointed_thing.under
            local player_name = user:get_player_name()
            local player_meta = minetest.get_meta(pos, player_name)
            
            -- Si la première position est déjà définie, enregistrez la deuxième
            if player_meta:get_string("selection_pos1") ~= "" then
                player_meta:set_string("selection_pos2", minetest.pos_to_string(pos))
                minetest.chat_send_player(player_name, "Deuxième position sélectionnée: " .. minetest.pos_to_string(pos))
            else
                -- Si la première position n'est pas encore définie, enregistrez-la
                player_meta:set_string("selection_pos1", minetest.pos_to_string(pos))
                minetest.chat_send_player(player_name, "Première position sélectionnée: " .. minetest.pos_to_string(pos))
            end
        end

        return itemstack
    end,
})
