-- Commande pour raccourcir /teleport en /tp
minetest.register_chatcommand("tp", {
    params = "<target>",
    description = "Teleport to a player or position (work only with player)",
    privs = {privs = true},
    func = function(player_name, param)
        local player = minetest.get_player_by_name(player_name)
        if not player then
            return false, "Player not found."
        end

        local args = param:split(" ")
        if #args == 0 then
            return false, "Usage: /tp <target>"
        end

        local target = args[1]
        local target_player = minetest.get_player_by_name(target)
        if target_player then
            -- Téléporter le joueur à la position du joueur cible
            local pos = target_player:get_pos()
            player:set_pos(pos)
            return true, "Teleported to " .. target
        else
            -- Téléporter le joueur à une position spécifiée
            local target_pos = minetest.string_to_pos(target)
            if target_pos then
                player:set_pos(target_pos)
                return true, "Teleported to " .. target
            else
                return false, "Target not found or invalid position."
            end
        end
    end,
})
