---------------------------------------------------------------------
-- config & global data
---------------------------------------------------------------------
math.randomseed(os.time())
ldf_race = {}

local S = core.get_translator("ldf_race")

local modpath = core.get_modpath("ldf_race")

function ldf_race.pos(pos)
   return(pos.x.." "..pos.y.." "..pos.z)
end

function ldf_race.rec(name, pos)
   return(name.." "..ldf_race.pos(pos))
end

function ldf_race.reset(name)
   for k in pairs(ldf_race) do
      if string.match(k, "^"..name.." ") then
         ldf_race[k] = nil
      end
   end
   core.chat_send_player(name, S("All race timers have been reset."))
end

if sethome.go then
   sethome.go = function(name)
      local pos = sethome.get(name)
      local player = minetest.get_player_by_name(name)
      if player and pos then
         player:set_pos(pos)
         ldf_race.reset(name)
         return true
      end
      return false
   end
end

dofile(modpath.."/nodes.lua")

