local S = core.get_translator("ldf_race")

--[[ RACE START
when a node at x y z is r-clicked by nick:
   save current time into "nick x y z",
   save "x y z" into "nick prior stage"
]]

core.register_node(
   "ldf_race:start",
   { tiles = {"ldf_checkers_start.png"},
     sounds = default.node_sound_stone_defaults(),
     description = S("Race Start"),
     groups = {oddly_breakable_by_hand=1},
     sounds = default.node_sound_stone_defaults(),
     after_place_node = function(pos, placer)
        local meta = core.get_meta(pos)
        local name = placer and placer:get_player_name() or ""
        meta:set_string("owner", name)
        meta:set_string("infotext", S("Race Start"))
     end,
     on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local name = clicker:get_player_name() or ""
        local privs = core.get_player_privs(name)
        if privs.fly then
           core.sound_play("access-denied", {gain = 1, pos = pos, max_hear_distance = 10}, true)
           return
        end
        core.sound_play("gong-bell", {gain = 1, pos = pos, max_hear_distance = 10}, true)
        ldf_race[ldf_race.rec(name, pos)] = core.get_us_time()
        ldf_race[name.." prior stage"] = ldf_race.pos(pos)
        core.chat_send_player(name, S("Go!"))
     end,
   }
)

--[[ RACE CHECKPOINT
]]

core.register_node(
   "ldf_race:checkpoint",
   { tiles = {"ldf_checkers_checkpoint.png"},
     sounds = default.node_sound_stone_defaults(),
     description = S("Race Checkpoint"),
     groups = {oddly_breakable_by_hand=1},
     sounds = default.node_sound_stone_defaults(),
     after_place_node = function(pos, placer)
        local meta = core.get_meta(pos)
        local name = placer and placer:get_player_name() or ""
        meta:set_string("owner", name)
        meta:set_string("infotext", S("Race Checkpoint"))
        local last_pos = ldf_race[name.." prior stage"]
        if last_pos then
           meta:set_string("ldf_prior_stage", last_pos)
           core.chat_send_player(name, S("Prior stage set: @1", last_pos))
        end
     end,
   }
)

--[[ RACE FINISH
when a node is placed by nick:
   if "nick last pos" is defined, record the last pos in the meta:
   record "x y z" in "ldf_prior_stage"

when a node at x y z is r-clicked by nick:
   retrieve "X Y Z" from the xyz's meta at "ldf_prior_stage",
   retrieve start time from "nick X Y Z",
   and if the above are available, possibly record a new record
   into the xyz's meta at "ldf_time nick", then zero out "nick X Y Z"

   if hit by a ladder, save the NICK of the first position on the ladder
   (lowest time) into meta at "ldf_no_one", and if hit by an axe, purge
   the record "ldf_time NICK"
]]

core.register_node(
   "ldf_race:finish",
   { tiles = {"ldf_checkers.png"},
     sounds = default.node_sound_stone_defaults(),
     description = S("Race Finish"),
     groups = {oddly_breakable_by_hand=1},
     sounds = default.node_sound_stone_defaults(),
     after_place_node = function(pos, placer)
        local meta = core.get_meta(pos)
        local name = placer and placer:get_player_name() or ""
        meta:set_string("owner", name)
        meta:set_string("infotext", S("Race Finish (owned by @1)", name))
        meta:set_string("ldf_no_one", nil)
        local last_pos = ldf_race[name.." prior stage"]
        if last_pos then
           meta:set_string("ldf_prior_stage", last_pos)
           core.chat_send_player(name, S("Prior stage set: @1", last_pos))
        end
     end,
     on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        local finish_time = core.get_us_time()
        local meta = core.get_meta(pos)
        local name = clicker and clicker:get_player_name() or ""
        local rec = name.." "..meta:get_string("ldf_prior_stage")
        local rec_time = ldf_race[rec]
        local item = clicker:get_wielded_item()
        local item_name = item:get_name()
        local use_sound = "gong-bell"
        if rec_time then
           local delta = finish_time - rec_time
           local seconds = delta/1000000
           local old_time = meta:get_int("ldf_time "..name)
           local old_seconds = old_time/1000000
           if (not old_time) or old_time == 0 or old_time > delta then
              core.chat_send_player(name, S("New personal best: @1 s (was @2 s)", seconds, old_seconds))
              meta:set_int("ldf_time "..name, delta)
           else
              core.chat_send_player(name, S("Time: @1 s (personal best: @2 s)", seconds, old_seconds))
           end
           ldf_race[rec] = nil
        else
           core.chat_send_player(name, S("Start this race at @1", meta:get_string("ldf_prior_stage")))
           use_sound = "access-denied"
        end
        if item_name == ("default:ladder_wood") then
           local best_times = {}
           for k in pairs(meta:to_table().fields) do
              local r = string.match(k, "ldf_time (.*)")
              if r then
                 best_times[r] = meta:get_int(k)
              end
           end
           local sorted_times = {}
           for k in pairs(best_times) do
              table.insert(sorted_times, k)
           end
           local comp = function(a, b)
              return(best_times[a] < best_times[b])
           end
           table.sort(sorted_times, comp)
           core.chat_send_player(name, S("Best times:"))
           for k in pairs(sorted_times) do
              core.chat_send_player(name, k..".  "..sorted_times[k].."  "..best_times[sorted_times[k]]/1000000)
           end

           meta:set_string("ldf_no_one", sorted_times[1])

           use_sound = "page-turn-big-book"
        end
        if string.match(item_name,"^default:axe_")
           and meta:get_string("owner") == name then
           local no_one = meta:get_string("ldf_no_one")
           if no_one then
              meta:set_string("ldf_time "..no_one, nil)
              meta:set_string("ldf_no_one", nil)
              core.chat_send_player(name, S("Record purged: @1", no_one))
           end
        end
        core.sound_play(use_sound, {gain = 1, pos = pos, max_hear_distance = 10}, true)
     end,
   }
)

core.register_craft(
   {
      output = "ldf_race:start",
      recipe = {
         {"dye:green", "dye:black", "dye:green"},
         {"dye:black", "dye:green", "dye:black"},
         {"dye:green", "dye:black", "dye:green"}
      }
   }
)

core.register_craft(
   {
      output = "ldf_race:checkpoint",
      recipe = {
         {"dye:blue", "dye:black", "dye:blue"},
         {"dye:black", "dye:blue", "dye:black"},
         {"dye:blue", "dye:black", "dye:blue"}
      }
   }
)

core.register_craft(
   {
      output = "ldf_race:finish",
      recipe = {
         {"dye:white", "dye:black", "dye:white"},
         {"dye:black", "dye:white", "dye:black"},
         {"dye:white", "dye:black", "dye:white"}
      }
   }
)

core.register_node(
   "ldf_race:mysterious_force",
   { tiles = {"ldf_force.png"},
     -- sounds = default.node_sound_glass_defaults(),
     description = "Mysterious Force",
     -- groups = ,
     drawtype = "glasslike",
     paramtype = "light",
     sunlight_propagates = true,
     use_texture_alpha = "blend",
   }
)

