inital_combat_healing = {}
inital_combat_healing.settings = {}
inital_combat_healing.settings.heal_duration = 1.0
inital_combat_healing.settings.ticks_per_second = 20.0
inital_combat_healing.settings.hp_per_tick = 1
inital_combat_healing.settings.cooldown = 120.0
inital_combat_healing.playerlist = {}
inital_combat_healing.last_values = {}


--cooldown initilization
--undamaged_healing_seconds_per_tick
do
	inital_combat_healing.milisecond_times = {}
	inital_combat_healing.milisecond_times.cooldown = math.floor(inital_combat_healing.settings.cooldown*1000)
	inital_combat_healing.milisecond_times.duration = math.floor(inital_combat_healing.settings.heal_duration*1000)
	local function increase_hp(player,ammount)
		player:set_hp(player:get_hp()+ammount)
	end
	
	local init_cooldown = adjustable_cooldowns.functions.init_cooldown

	init_cooldown("inital_combat_healing:healing_seconds_per_tick",1.0/inital_combat_healing.settings.ticks_per_second,function(player)
		increase_hp(player,inital_combat_healing.playerlist[player:get_player_name()])
		--minetest.chat_send_all("damage regeneration healing ticks per second finished")
	end,nil,nil,true)
	init_cooldown("inital_combat_healing:healing_cooldown",inital_combat_healing.settings.cooldown,function(player)
		local playername = player:get_player_name()
		adjustable_cooldowns.functions.disable_cooldown(playername,"inital_combat_healing:healing_cooldown")
		adjustable_cooldowns.functions.reset_cooldown(playername,"inital_combat_healing:healing_duration")
		adjustable_cooldowns.functions.reset_cooldown(playername,"inital_combat_healing:healing_seconds_per_tick")
		hb.change_hudbar(player,"initial_combat_healing_indicator",inital_combat_healing.milisecond_times.duration,inital_combat_healing.milisecond_times.duration,"inital_combat_healing_charged_indicator.png")
		--minetest.chat_send_all("damage regeneration healing is able to work again")
	end)
	init_cooldown("inital_combat_healing:healing_duration",inital_combat_healing.settings.heal_duration,function(player)
		local playername = player:get_player_name()
		adjustable_cooldowns.functions.enable_cooldown(playername,"inital_combat_healing:healing_cooldown")
		adjustable_cooldowns.functions.disable_cooldown(playername,"inital_combat_healing:healing_seconds_per_tick")
		adjustable_cooldowns.functions.disable_cooldown(playername,"inital_combat_healing:healing_duration")
		hb.change_hudbar(player,"initial_combat_healing_indicator",inital_combat_healing.milisecond_times.cooldown,inital_combat_healing.milisecond_times.cooldown,"inital_combat_healing_uncharged_indicator.png")
		--minetest.chat_send_all("damage regeneration healing has been deactivated")
	end,nil,false,true)
	
	adjustable_cooldowns.functions.init_group("combat_healing_speed")
	adjustable_cooldowns.functions.add_group("inital_combat_healing:healing_duration","combat_healing_speed")
	adjustable_cooldowns.functions.add_group("inital_combat_healing:healing_seconds_per_tick","combat_healing_speed")
end

minetest.register_on_player_hpchange(function(player,hp_change,reason)
	if hp_change >= 0 then
		return
	end
	local playername = player:get_player_name()
	--minetest.chat_send_all(tostring(playername))
	--minetest.chat_send_all(tostring(player))
	if not adjustable_cooldowns.functions.is_disabled(playername,"inital_combat_healing:healing_cooldown") or not adjustable_cooldowns.functions.is_disabled(playername,"inital_combat_healing:healing_duration") then
		--minetest.chat_send_all(tostring(playername))
		--minetest.chat_send_all(type(playername))
		return
	end
	adjustable_cooldowns.functions.enable_cooldown(playername,"inital_combat_healing:healing_duration")
	adjustable_cooldowns.functions.enable_cooldown(playername,"inital_combat_healing:healing_seconds_per_tick")
	--minetest.chat_send_all("Enabled healing seconds per tick and enabled healing duration cooldowns")
	return
end,false)


--initialize player hudbars
hb.register_hudbar("initial_combat_healing_indicator",0x8b0000,"Combat Health",{bar = "inital_combat_healing_bar.png",icon = "inital_combat_healing_uncharged_indicator.png",inital_combat_healing.settings.cooldown,inital_combat_healing.settings.cooldown})
minetest.register_globalstep(function(dtime)
	local players = minetest.get_connected_players()
	for index,player in pairs(players) do
		local playername = player:get_player_name()
		if adjustable_cooldowns.functions.is_disabled(playername,"inital_combat_healing:healing_cooldown") then
			hb.change_hudbar(player,"initial_combat_healing_indicator",math.floor(adjustable_cooldowns.functions.remaining_cooldown(playername,"inital_combat_healing:healing_duration")*1000))
		else
			hb.change_hudbar(player,"initial_combat_healing_indicator",math.floor(adjustable_cooldowns.functions.remaining_cooldown(playername,"inital_combat_healing:healing_cooldown")*1000))
		end
		--[[minetest.chat_send_all(tostring(new_val))
		minetest.chat_send_all(tostring(max_val))
		minetest.chat_send_all(hb_icon)--]]
		--if inital_combat_healing.last_values[playername] == new_val then return end
		--inital_combat_healing.last_values[playername] = new_val
		--minetest.chat_send_all(tostring(player))
		--minetest.chat_send_all(playername)
		--minetest.chat_send_all(player:get_player_name())
		--[[
		local i = 1
		for index, val in pairs(hb.get_hudbar_state(player,"initial_combat_healing_indicator")) do
			minetest.chat_send_all(tostring(i))
			minetest.chat_send_all(index..": "..val)
			i = i + 1
		end--]]
	end
end)


--damage regeneration functions
inital_combat_healing.functions = {}
function inital_combat_healing.functions.increase_healing_per_tick(playername,added_hp)
	if type(added_hp) ~= "number" then
		minetest.log("error","Tried to call inital_combat_healing.inital_combat_healing.increase_healing_per_tick without a valid number")
		return false
	end
	if type(playername) ~= "string" or inital_combat_healing.playerlist[playername] == nil then
		minetest.log("error","Tried to call inital_combat_healing.inital_combat_healing.increase_healing_per_tick without a valid name")
		return false
	end
	inital_combat_healing.playerlist[playername] = inital_combat_healing.playerlist + added_hp
	return true
end

function inital_combat_healing.functions.increase_duration(playername,duration_increase_multiplier)
	if type(duration_increase) ~= "number" then
		minetest.log("error","Tried to call inital_combat_healing.inital_combat_healing.increase_duration without a valid number")
		return false
	end
	if type(playername) ~= "string" or inital_combat_healing.playerlist[playername] == nil then
		minetest.log("error","Tried to call inital_combat_healing.inital_combat_healing.increase_duration without a valid name")
		return false
	end
	return adjustable_cooldowns.functions.multiply_individual_cooldown(playername,"inital_combat_healing:healing_duration",1.0/duration_increase_multiplier)
end

function inital_combat_healing.functions.reduce_cooldown(playername,duration_multipler)
	if type(duration_multipler) ~= "number" then
		minetest.log("error","Tried to call inital_combat_healing.reduce_cooldown.increase_duration without a valid number")
		return false
	end
	if type(playername) ~= "string" or inital_combat_healing.playerlist[playername] == nil then
		minetest.log("error","Tried to call inital_combat_healing.reduce_cooldown.increase_duration without a valid name")
		return false
	end
	return adjustable_cooldowns.functions.multiply_individual_cooldown(playername,"inital_combat_healing:healing_cooldown",duration_multipler)
end

function increase_healing_speed(playername,multiplier)
	if type(multiplier) ~= "number" then
		minetest.log("error","Tried to call inital_combat_healing.reduce_cooldown.increase_duration without a valid number")
		return false
	end
	if type(playername) ~= "string" or inital_combat_healing.playerlist[playername] == nil then
		minetest.log("error","Tried to call inital_combat_healing.reduce_cooldown.increase_duration without a valid name")
		return false
	end
	return adjustable_cooldowns.functions.multiply_individual_cooldown(playername,"combat_healing_speed",multiplier)
end


--file handling
function inital_combat_healing.save_to_file()
	local savetable = {}
	savetable.playerlist = inital_combat_healing.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/inital_combat_healing.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[inital_combat_healing] Wrote inital_combat_healing data into "..filepath..".")
	else
		minetest.log("error","[inital_combat_healing] Failed to write inital_combat_healing data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	inital_combat_healing.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[inital_combat_healing] Server shuts down. Rescuing data to inital_combat_healing.")
	inital_combat_healing.save_to_file()
end)

do --load the file, if any
	local filepath = minetest.get_worldpath().."/inital_combat_healing.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[inital_combat_healing] inital_combat_healing.mt opened")
		local string = file:read()
		io.close(file)
		if string ~= nil then
			local savetable = minetest.deserialize(string)
			inital_combat_healing.playerlist = savetable.playerlist
			minetest.log("action","[inital_combat_healing] inital_combat_healing.mt successfully read")
		end
	end
end


--new player initilization
minetest.register_on_joinplayer(function(player)
	playername = player:get_player_name()
	hb.init_hudbar(player,"initial_combat_healing_indicator",1,1)
	if inital_combat_healing.playerlist[playername] == nil then
		inital_combat_healing.playerlist[playername] = inital_combat_healing.settings.hp_per_tick
	end
	if adjustable_cooldowns.functions.is_disabled(playername,"inital_combat_healing:healing_cooldown") then
		hb.change_hudbar(player,"initial_combat_healing_indicator",nil,inital_combat_healing.milisecond_times.duration,"inital_combat_healing_charged_indicator.png")
	else
		hb.change_hudbar(player,"initial_combat_healing_indicator",nil,inital_combat_healing.milisecond_times.cooldown,"inital_combat_healing_uncharged_indicator.png")
	end
	--inital_combat_healing.last_values[playername] = 0
end)