mystical_saturation = {}
mystical_saturation.settings = {}
mystical_saturation.playerlist = {}
mystical_saturation.settings.cooldown_time = 0.2
mystical_saturation.settings.max_saturation = 5

minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	if mystical_saturation.playerlist[playername] == nil then --initialzie the cooldowns
		--minetest.chat_send_all("Initilaziling "..playername.."'s saturation.")
		mystical_saturation.playerlist[playername] = {}
		mystical_saturation.playerlist[playername].saturation = 0
		mystical_saturation.playerlist[playername].max_saturation = mystical_saturation.settings.max_saturation
		mystical_saturation.playerlist[playername].last_saturation_eaten = 0
	end
	local values = mystical_saturation.playerlist[playername]
	hb.init_hudbar(player, "saturation",values.saturation,values.max_saturation)
end)

adjustable_cooldowns.functions.init_cooldown("mystical_saturation:staturation",mystical_saturation.settings.cooldown_time,function(player)
	--[[if type(player) == "nil" then
		minetest.log("error","Player passed to mystical saturation on cooldown is nil")
		return
	end--]]
	local name = player:get_player_name()
	--mystical_saturation.hud_update(name)
	if player:get_hp() > 0 and mystical_saturation.playerlist[name].saturation > 0 and player:get_hp() < health_monoid:value(player) then
		player:set_hp(player:get_hp()+1)
		mystical_saturation.playerlist[name].saturation = mystical_saturation.playerlist[name].saturation - 1
		mystical_saturation.hud_update(name)
	end
end)

hb.register_hudbar("saturation",0xFFFFFF,"saturation",
{bar = "mystical_saturation_apple_hudbar.png",icon = "mystical_saturation_apple.png"},
0, 5,false)

function mystical_saturation.hud_update(playername)
	local player = minetest.get_player_by_name(playername)
	if player ~= nil then
		hb.change_hudbar(player, "saturation", mystical_saturation.playerlist[playername].saturation, math.floor(mystical_saturation.playerlist[playername].max_saturation+0.5))
	end
end

minetest.register_on_item_eat(function(hp_change,replace_with_item,itemstack,user)
	--minetest.chat_send_player(user:get_player_name(),hp_change)
	local missing_health = health_monoid:value(user) - user:get_hp()
	--minetest.chat_send_player(user:get_player_name(),missing_health)
	if hp_change <= missing_health then return end
	local saturation = hp_change - missing_health
	--minetest.chat_send_player(user:get_player_name(),saturation)
	local playervalues = mystical_saturation.playerlist[user:get_player_name()]
	local max_saturation = playervalues.max_saturation - playervalues.saturation
	--minetest.chat_send_all(tostring(playervalues.max_saturation))
	--minetest.chat_send_all(tostring(playervalues.saturation))
	--minetest.chat_send_all(tostring(max_saturation))
	--minetest.chat_send_all(tostring(max_saturation))
	if playervalues.saturation == playervalues.max_saturation then
		playervalues.last_saturation_eaten = 0
		return
	end
	playervalues.saturation = playervalues.saturation + saturation
	--minetest.chat_send_all(tostring(playervalues.max_saturation))
	if playervalues.saturation > math.floor(playervalues.max_saturation+0.5) then
		playervalues.saturation = math.floor(playervalues.max_saturation+0.5)
	end
	mystical_saturation.playerlist[playername].last_saturation_eaten = math.min(saturation,max_saturation)
	--minetest.chat_send_all(tostring(last_saturation_eaten))
	mystical_saturation.hud_update(user:get_player_name())
	--minetest.chat_send_all(playervalues.max_saturation)
end)

function mystical_saturation.save_to_file()
	local savetable = {}
	savetable.playerlist = mystical_saturation.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/mystical_saturation.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[mystical_saturation] Wrote mystical_saturation data into "..filepath..".")
	else
		minetest.log("error","[mystical_saturation] Failed to write mystical_saturation data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	mystical_saturation.save_to_file()
	mystical_saturation.hud_remove(player:get_player_name())
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[mystical_saturation] Server shuts down. Rescuing data to mystical_saturation.")
	mystical_saturation.save_to_file()
end)

do --load the file, if any
	local filepath = minetest.get_worldpath().."/mystical_saturation.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[mystical_saturation] mystical_saturation.mt opened")
		local string = file:read()
		io.close(file)
		if string ~= nil then
			local savetable = minetest.deserialize(string)
			mystical_saturation.playerlist = savetable.playerlist
			minetest.log("action","[mystical_saturation] mystical_saturation.mt successfully read")
		end
	end
end

function mystical_saturation.add(value,playername)
	if mystical_saturation.playerlist[playername] == nil then
		minetest.log("error","attempted to call mystical_saturation.add_saturation without a valid name.")
		return false
	end
	if type(value) ~= "number" then
		minetest.log("error","attempted to call mystical_saturation.add_saturation without a valid ammount.")
		return false
	end
	if value <= 0 then return false end
	mystical_saturation.playerlist[playername].saturation = math.floor(mystical_saturation.playerlist[playername].saturation + value + 0.5)
	if mystical_saturation.playerlist[playername].saturation > math.floor(mystical_saturation.playerlist[playername].max_saturation + 0.5) then
		mystical_saturation.playerlist[playername].saturation = math.floor(mystical_saturation.playerlist[playername].max_saturation + 0.5)
	end
	mystical_saturation.hud_update(playername)
	return true
end

function mystical_saturation.add_max(value,playername)
	--minetest.chat_send_all(playername)
	if mystical_saturation.playerlist[playername] == nil then
		minetest.log("error","attempted to call mystical_saturation.add_saturation without a valid name.")
		return false
	end
	if type(value) ~= "number" then
		minetest.log("error","attempted to call mystical_saturation.add_saturation without a valid ammount.")
		return false
	end
	if value <= 0 then return false end
	mystical_saturation.playerlist[playername].max_saturation = mystical_saturation.playerlist[playername].max_saturation + value
	mystical_saturation.hud_update(playername)
	return true
end

function mystical_saturation.get(playername)
	return mystical_saturation.playerlist[playername].saturation
end

function mystical_saturation.get_max(playername)
	return math.floor(mystical_saturation.playerlist[playername].max_saturation+0.5)
end

function mystical_saturation.get_last_saturation(playername)
	return mystical_saturation.playerlist[playername].last_saturation_eaten
end

minetest.register_on_respawnplayer(function(player)
	local playername = player:get_player_name()
	mystical_saturation.playerlist[playername].saturation = 0
	 mystical_saturation.hud_update(playername)
end)