undying_charges = {}
undying_charges.playerlist = {}
undying_charges.dying_functions = {}
undying_charges.dying_functions.before_charge_application = {}
undying_charges.dying_functions.on_charge_activation = {}
undying_charges.dying_functions.after_charge_application = {}
undying_charges.dying_functions.on_charge_fail = {}
undying_charges.add_functions = {}

do
	local filepath = minetest.get_worldpath().."/undying_charges.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[undying_charges] undying_charges.mt opened")
		local string = file:read()
		io.close(file)
		if string ~= nil then
			local savetable = minetest.deserialize(string)
			undying_charges.playerlist = savetable.playerlist
			minetest.log("action","[undying_charges] undying_charges.mt successfully read")
		end
	end
end

function undying_charges.save_to_file()
	local savetable = {}
	savetable.playerlist = undying_charges.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/undying_charges.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[undying_charges] Wrote undying_charges data into "..filepath..".")
	else
		minetest.log("error","[undying_charges] Failed to write Magic_sheild data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	undying_charges.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[undying_charges] Server shuts down. Rescuing data to undying_charges.")
	undying_charges.save_to_file()
end)

minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	if undying_charges.playerlist[playername] == nil then
		undying_charges.playerlist[playername] = 0
	end
end)

minetest.register_on_player_hpchange(function(player,hp_change,reason)
	local function is_dying (player)
		return hp_change < 0 and hp_change*-1 >= player:get_hp()
	end
	local function excute_functions(function_list)
		for i, executable in pairs(function_list) do
			hp_change = executable(player,hp_change) -- throws error of trying to excute a string as a function
			--minetest.chat_send_all(type(executable)) --tells me it is stored as a function
			--minetest.chat_send_all(type(function_list[i])) -- tells me same thing as above
		end
	end
	if not is_dying(player) then
		return hp_change
	end
	local playername = player:get_player_name()
	excute_functions(undying_charges.dying_functions.before_charge_application)
	if not is_dying(player) then
		return hp_change
	end
	if undying_charges.has_undying_charge(playername) and is_dying(player) then
		undying_charges.playerlist[playername] = undying_charges.playerlist[playername] - 1
		excute_functions(undying_charges.dying_functions.on_charge_activation)
		player:set_hp(65535)
		minetest.chat_send_all(playername .. " used an undying charge to escape death.")
		if undying_charges.playerlist[playername] == 1 then
			minetest.chat_send_player(playername, "You have 1 undying charge left.")
		else
			minetest.chat_send_player(playername, "You have "..undying_charges.get_charges(player).." undying charges left.")
		end
		hp_change = 0
		excute_functions(undying_charges.dying_functions.after_charge_application)
		return hp_change
	end
	excute_functions(undying_charges.dying_functions.on_charge_fail)
	return hp_change
end,true)
function undying_charges.get_charges(player)
	return undying_charges.playerlist[player:get_player_name()]
end
function undying_charges.add_charges(player,number)
	undying_charges.playerlist[player:get_player_name()] = undying_charges.playerlist[player:get_player_name()] + number
end
--minetest.register_privilege("undying_admin",{
--	description = "Can change a player's undying charges",
--	give_to_singleplayer = false,
--})
--[[ minetest.register_chatcommand("get_undying_charges",{
	privs = {
		undying_admin = true
	},
	func = function(name)
		return 
	end
}) ]]
minetest.register_craftitem("undying_charges:ankh",{
	description = "Ankh",
	inventory_image = "ankh.png",
	stack_max = 1,
	on_use = function(itemstack,user)
		--if undying_charges[user:get_player_name()] < 65535 then
			undying_charges.add_charges(user,1)
			minetest.chat_send_player(user:get_player_name(),"You successfully used an ankh and now have "..undying_charges.get_charges(user).." undying charges.")
			itemstack:take_item()
		--end
		return itemstack
	end,
	groups = {not_in_creative_inventory = 1,extra_life = 1}
})
if minetest.global_exists("dungeon_loot") then
	dungeon_loot.register({
		{name = "undying_charges:ankh",chance = 0.5,count = {1,1}}
	})
end
minetest.register_craftitem("undying_charges:uncharged_ankh",{
	description = "uncharged Ankh",
	inventory_image = "uncharged_ankh.png",
	stack_max = 1,
	on_use = function(itemstack,user)
		if user:get_hp() == 1 then
			itemstack:set_name("undying_charges:ankh")
			user:set_hp(2)
			minetest.chat_send_player(user:get_player_name(),"You successfully charged an ankh.")
		else
			minetest.chat_send_player(user:get_player_name(),"You must be on the brink of death to use this item.")
		end
		return itemstack
	end,
	groups = {not_in_creative_inventory = 1}
})
if minetest.get_modpath("default") then
	minetest.register_craft({
	output = "undying_charges:uncharged_ankh",
	recipe = {{"default:obsidian","default:diamondblock","default:obsidian"},
			  {"default:mese","default:bronzeblock","default:mese"},
			  {"default:diamondblock","default:mese","default:diamondblock"}}
	})
end
if minetest.get_modpath("mystic_runes") then
	minetest.register_craft({
	output = "undying_charges:uncharged_ankh",
	recipe = {"group:energy_element","group:energy_element","group:energy_element","group:light_element","group:dark_element","group:earth_element","group:air_element","group:water_element","mystic_runes:ultimate_fuel",},
	type = "shapeless"
	})
end

minetest.register_on_craft(function(itemstack,player)
	local name = itemstack:get_name()
	if name == "undying_charges:uncharged_ankh" then
		player:set_hp(player:get_hp()-10) --extract blood from the crafter
		player:set_breath(0) -- extract air from the crafter
	end
end)

function undying_charges.has_undying_charge(playername)
	return undying_charges.playerlist[playername] > 0
end

--functions need following arguments: player, hp_change; must also return: hp_change
--undying_charges.dying_functions.before_charge_application = {}
--undying_charges.dying_functions.on_charge_activation = {}
--undying_charges.dying_functions.after_charge_application = {}
--undying_charges.dying_functions.do_on_charge_fail = {}

function undying_charges.add_functions.do_before_charge_check(function_to_store)
	table.insert(undying_charges.dying_functions.before_charge_application,function_to_store)
end

function undying_charges.add_functions.do_before_charge(function_to_store)
	table.insert(undying_charges.dying_functions.on_charge_activation,function_to_store)
end

function undying_charges.add_functions.do_after_charge(function_to_store)
	table.insert(undying_charges.dying_functions.after_charge_application,function_to_store)
end

function undying_charges.add_functions.do_on_death(function_to_store)
	table.insert(undying_charges.dying_functions.on_charge_fail,function_to_store)
end