--make initialized cooldowns reduce time left
minetest.register_globalstep(function(dtime)
	local players = minetest.get_connected_players()
	local player_cooldowns = adjustable_cooldowns.playerlist
	local cooldowns = adjustable_cooldowns.cooldowns
	local cooldown_groups = adjustable_cooldowns.groups
	for i=1,#players do
		local playername = players[i]:get_player_name()
		local cooldown_modifications = player_cooldowns[playername].cooldowns
		local cooldown_group_modifications = player_cooldowns[playername].groups
		local function group_recursion(groupname)
			local value = 1
			for index,group in pairs(cooldown_groups[groupname]) do
				value = value * group_recursion(group)
			end
			value = value*cooldown_group_modifications[groupname]
			return value
		end
		for modname,cooldown_subgroup in pairs(cooldowns) do
			for subname, cooldown_info in pairs(cooldown_subgroup) do
				if not cooldown_modifications[modname][subname].is_disabled then
					local cooldown_info = cooldowns[modname][subname]
					local modification_info = cooldown_modifications[modname][subname]
					local modification_multiplier = 1.0
					if cooldown_info.universal_modification then
						modification_multiplier = player_cooldowns[playername].cooldown_rate
					end
					modification_multiplier = modification_multiplier * modification_info.cooldown_rate
					for index, groupname in pairs(cooldown_info.groups) do
						modification_multiplier = modification_multiplier * group_recursion(groupname)
					end
					local final_time = dtime * modification_multiplier
					if modification_info.current_cooldown <= 0 or final_time >= modification_info.current_cooldown then
						cooldown_info.on_finished_cooldown(players[i])
						modification_info.current_cooldown = cooldown_info.base_cooldown
					else
						modification_info.current_cooldown = modification_info.current_cooldown - final_time
					end
				end
			end
		end
	end
end)

minetest.register_on_respawnplayer(function(player)
	playername = player:get_player_name()
	local cooldowns = adjustable_cooldowns.cooldowns
	for modname,cooldown_subgroup in pairs(cooldowns) do
		for subname, cooldown_info in pairs(cooldown_subgroup) do
			adjustable_cooldowns.playerlist[playername].cooldowns[modname][subname].current_cooldown = adjustable_cooldowns.cooldowns[modname][subname].respawn_cooldown
		end
	end
end)