out_of_combat_healing = {}
out_of_combat_healing.settings = {}
out_of_combat_healing.settings.hp_per_tick = 1
out_of_combat_healing.settings.ticks_per_second = 5.0
out_of_combat_healing.settings.undamaged_time_before_heal = 20.0
out_of_combat_healing.playerlist = {}


--cooldown initilization
do
	local function increase_hp(player,ammount)
		player:set_hp(player:get_hp()+ammount)
	end
	
	local init_cooldown = adjustable_cooldowns.functions.init_cooldown
	--local playerlist = out_of_combat_healing.playerlist

	init_cooldown("out_of_combat_healing:seconds_per_tick",1.0/out_of_combat_healing.settings.ticks_per_second,function(player)
		increase_hp(player,out_of_combat_healing.playerlist[player:get_player_name()])
		--minetest.chat_send_all("undamged healing ticks per second finished")
	end,nil,nil,true)
	init_cooldown("out_of_combat_healing:cooldown",out_of_combat_healing.settings.undamaged_time_before_heal,function(player)
		local playername = player:get_player_name()
		adjustable_cooldowns.functions.reset_cooldown(playername,"out_of_combat_healing:seconds_per_tick")
		adjustable_cooldowns.functions.enable_cooldown(playername,"out_of_combat_healing:seconds_per_tick")
		adjustable_cooldowns.functions.disable_cooldown(playername,"out_of_combat_healing:cooldown")
		--minetest.chat_send_all("undamaged healing ticks per second enabled")
	end,nil,false)
end

--delayed regeneration functions
minetest.register_on_player_hpchange(function(player,hp_change,reason)
	if hp_change >= 0 then return hp_change end
	playername = player:get_player_name()
	adjustable_cooldowns.functions.disable_cooldown(playername,"out_of_combat_healing:seconds_per_tick")
	adjustable_cooldowns.functions.reset_cooldown(playername,"out_of_combat_healing:cooldown")
	adjustable_cooldowns.functions.enable_cooldown(playername,"out_of_combat_healing:cooldown")
	return hp_change
end,false)


out_of_combat_healing.functions = {}
function out_of_combat_healing.functions.adjust_tick_rate(playername,tick_percentage)
	if type(tick_percentage) ~= "number" then
		minetest.log("error","Tried to call out_of_combat_healing.undamaged_healing.adjust_tick_rate without a number on the tick percentage")
		return false
	end
	tick_percentage_reciprical = tick_percentage/100
	tick_percentage_reciprical = tick_percentage_reciprical - 1
	tick_percentage_reciprical = 1/tick_percentage_reciprical
	tick_percentage_reciprical = tick_percentage_reciprical + 1
	tick_percentage_reciprical = tick_percentage_reciprical*100
	return adjustable_cooldowns.add_player_cooldown(playername,"out_of_combat_healing:seconds_per_tick",tick_percentage_reciprical)
end

function out_of_combat_healing.functions.increase_healing_per_tick(playername,health)
	if type(health) ~= "number" then
		minetest.log("error","Tried to call out_of_combat_healing.undamaged_healing.increase_healing_per_tick without a number on the additional healing per tick")
		return false
	end
	if type(playername) ~= "string" then
		minetest.log("error","Tried to call out_of_combat_healing.undamaged_healing.increase_healing_per_tick without a string on the playername")
		return false
	end
	--local undamage_health_per_tick = out_of_combat_healing.playerlist[playername]
	if type(out_of_combat_healing.playerlist[playername]) == nil then
		minetest.log("error","Tried to call out_of_combat_healing.undamaged_healing.increase_healing_per_tick without a valid playername")
		return false
	end
	if health + out_of_combat_healing.playerlist[playername] < 0 then
		out_of_combat_healing.playerlist[playername] = 0
		return true
	end
	out_of_combat_healing.playerlist[playername] = out_of_combat_healing.playerlist[playername] + health
	return true
end

function out_of_combat_healing.functions.adjust_damage_cooldown(playername,cooldown_percentage)
	return adjustable_cooldowns.add_player_cooldown(playername,"out_of_combat_healing:cooldown",cooldown_percentage)
end


--file handling
function out_of_combat_healing.save_to_file()
	local savetable = {}
	savetable.playerlist = out_of_combat_healing.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/out_of_combat_healing.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[out_of_combat_healing] Wrote out_of_combat_healing data into "..filepath..".")
	else
		minetest.log("error","[out_of_combat_healing] Failed to write out_of_combat_healing data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	out_of_combat_healing.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[out_of_combat_healing] Server shuts down. Rescuing data to out_of_combat_healing.")
	out_of_combat_healing.save_to_file()
end)

do --load the file, if any
	local filepath = minetest.get_worldpath().."/out_of_combat_healing.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[out_of_combat_healing] out_of_combat_healing.mt opened")
		local string_to_read = file:read()
		io.close(file)
		if string_to_read ~= nil then
			local savetable = minetest.deserialize(string_to_read)
			out_of_combat_healing.playerlist = savetable.playerlist
			minetest.log("action","[out_of_combat_healing] out_of_combat_healing.mt successfully read")
		end
	end
end


--new player initilization
minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	if out_of_combat_healing.playerlist[playername] == nil then
		out_of_combat_healing.playerlist[playername] =  out_of_combat_healing.settings.hp_per_tick
	end
end)

--heal to full -> go to full saturation -> growth multiplier (add to current base) {eating}
--heal to full -> growth multiplier (add to current base) {temperary effects}
--upgrade growth multiplier

--out_of_combat_healing.playerlist[playername].heal_effiecency -> contains: heal_boost, heal_increase (1 is 100% boost)
--out_of_combat_healing.playerlist[playername].undamaged_healing -> contains: hp_per_tick
--out_of_combat_healing.playerlist[playername].damage_regeneration -> contains: hp_per_tick