local function initalize_player_cooldowns(playername)
	local player_cooldown_checks = adjustable_cooldowns.playerlist[playername]
	for modname,cooldowns in pairs(adjustable_cooldowns.cooldowns) do
		if player_cooldown_checks.cooldowns[modname] == nil then
			player_cooldown_checks.cooldowns[modname] = {}
		end
		for cooldownname,cooldown_values in pairs(cooldowns) do
			if player_cooldown_checks.cooldowns[modname][cooldownname] == nil then
				player_cooldown_checks.cooldowns[modname][cooldownname] = {}
				player_cooldown_checks.cooldowns[modname][cooldownname].cooldown_rate = 1.0
				player_cooldown_checks.cooldowns[modname][cooldownname].current_cooldown = cooldown_values.respawn_cooldown
				player_cooldown_checks.cooldowns[modname][cooldownname].is_disabled = cooldown_values.disabled_on_default
			end
		end
	end
end

local function initalize_player_groups(playername)
	local player_cooldown_checks = adjustable_cooldowns.playerlist[playername]
	for groupname,groupvalue in pairs(adjustable_cooldowns.groups) do
		if groupvalue == nil then
			adjustable_cooldowns.groups[groupname] = 1.0
		end
	end
end

--initialize new player's cooldowns to default values or double check returning player's cooldowns
minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	if adjustable_cooldowns.playerlist[playername] == nil then --initialzie the cooldowns
		adjustable_cooldowns.playerlist[playername] = {}
		local player_cooldown_checks = adjustable_cooldowns.playerlist[playername]
		player_cooldown_checks.cooldown_rate = 1.0
		player_cooldown_checks.cooldowns = {}
		player_cooldown_checks.groups = {}
	end
	initalize_player_cooldowns(playername)
	initalize_player_groups(playername)
end)