heal_efficiency_overeat = {}
heal_efficiency_overeat.settings = {}
heal_efficiency_overeat.settings.health_growth_increase = 0.0
heal_efficiency_overeat.settings.max_health_growth = 1.0
heal_efficiency_overeat.settings.hp_boost_recovered_on_death = 0.50
heal_efficiency_overeat.playerlist = {}

minetest.register_on_item_eat(function(hp_change,replace_with_item,itemstack,user)
	--heal_effiecency
	local username = user:get_player_name()
	local heal_modify = heal_efficiency_overeat.playerlist[username].heal_boost_increase
	local max_heal = heal_efficiency_overeat.playerlist[username].max_heal_boost
	local heal_left = max_heal - heal_efficiency_overeat.playerlist[username].current_heal_boost
	if heal_modify <= 0 or heal_left <= 0 then return end
	local missing_health = health_monoid:value(user) - user:get_hp()
	if hp_change <= missing_health then return end
	local overheal = hp_change - missing_health
	if minetest.get_modpath("mystical_saturation") then
		local last_saturation = mystical_saturation.get_last_saturation(username)
		--minetest.chat_send_all(last_saturation)
		overheal = math.max(overheal - last_saturation,0)
	end
	local modified_heal = math.min(heal_modify * overheal,heal_left)
	heal_efficiency_monoid:del_change(user,"heal_efficiency_overeat:heal_boost")
	heal_efficiency_overeat.playerlist[username].current_heal_boost = heal_efficiency_overeat.playerlist[username].current_heal_boost + modified_heal
	heal_efficiency_monoid:add_change(user,heal_efficiency_overeat.playerlist[username].current_heal_boost,"heal_efficiency_overeat:heal_boost")
	minetest.chat_send_player(username,"Your overeat heal efficiency is now "..tostring(heal_efficiency_monoid:value(user)*100).."%.")
end)


--file handling
function heal_efficiency_overeat.save_to_file()
	local savetable = {}
	savetable.playerlist = heal_efficiency_overeat.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/heal_efficiency_overeat.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[heal_efficiency_overeat] Wrote heal_efficiency_overeat data into "..filepath..".")
	else
		minetest.log("error","[heal_efficiency_overeat] Failed to write heal_efficiency_overeat data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	heal_efficiency_overeat.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[heal_efficiency_overeat] Server shuts down. Rescuing data to heal_efficiency_overeat.")
	heal_efficiency_overeat.save_to_file()
end)

do --load the file, if any
	local filepath = minetest.get_worldpath().."/heal_efficiency_overeat.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[heal_efficiency_overeat] heal_efficiency_overeat.mt opened")
		local string = file:read()
		io.close(file)
		if string ~= nil then
			local savetable = minetest.deserialize(string)
			heal_efficiency_overeat.playerlist = savetable.playerlist
			minetest.log("action","[heal_efficiency_overeat] heal_efficiency_overeat.mt successfully read")
		end
	end
end


--increase functions
heal_efficiency_overeat.functions = {}
function heal_efficiency_overeat.functions.increase_health_boost(playername,boost_increase)
	if type(playername) ~= "string" or heal_efficiency_overeat.playerlist[playername] == nil then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.increase_health_boost without a valid playername.") end
	if type(boost_increase) ~= "number" then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.increase_health_boost without a valid health boost increase.") end
	heal_efficiency_overeat.playerlist[playername].heal_boost_increase = heal_efficiency_overeat.playerlist[playername].heal_boost_increase + boost_increase
end
function heal_efficiency_overeat.functions.reduce_health_boost(playername,boost_decrease)
	if type(playername) ~= "string" or heal_efficiency_overeat.playerlist[playername] == nil then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.reduce_health_boost without a valid playername.") end
	if type(boost_decrease) ~= "number" then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.reduce_health_boost without a valid health boost increase.") end
	heal_efficiency_overeat.playerlist[playername].heal_boost_increase = heal_efficiency_overeat.playerlist[playername].heal_boost_increase - boost_decrease
end
function heal_efficiency_overeat.functions.increase_max_boost(playername,max_increase)
	if type(playername) ~= "string" or heal_efficiency_overeat.playerlist[playername] == nil then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.increase_max_boost without a valid playername.") end
	if type(max_increase) ~= "number" then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.increase_max_boost without a valid health boost increase.") end
	heal_efficiency_overeat.playerlist[playername].max_health_boost = heal_efficiency_overeat.playerlist[playername].max_health_boost + max_increase
end
function heal_efficiency_overeat.functions.reduce_max_boost(playername,max_decrease)
	if type(playername) ~= "string" or heal_efficiency_overeat.playerlist[playername] == nil then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.reduce_max_boost without a valid playername.") end
	if type(max_decrease) ~= "number" then minetest.log("error", "Tried to call heal_efficiency_overeat.functions.reduce_max_boost without a valid health boost increase.") end
	heal_efficiency_overeat.playerlist[playername].max_health_boost = heal_efficiency_overeat.playerlist[playername].max_health_boost - max_increase
end


--reset player heal boost
minetest.register_on_respawnplayer(function(player)
	heal_efficiency_monoid:del_change(player,"heal_efficiency_overeat:heal_boost")
	heal_efficiency_overeat.playerlist[playername].current_heal_boost = heal_efficiency_overeat.playerlist[playername].current_heal_boost * math.min(heal_efficiency_overeat.settings.hp_boost_recovered_on_death,1)
	heal_efficiency_monoid:add_change(player,heal_efficiency_overeat.playerlist[playername].current_heal_boost,"heal_efficiency_overeat:heal_boost")
	minetest.chat_send_player(playername,"Your overeat heal efficiency is now "..tostring(heal_efficiency_monoid:value(player)*100).."%.")
end)


--new player initilization
minetest.register_on_joinplayer(function(player)
	playername = player:get_player_name()
	if heal_efficiency_overeat.playerlist[playername] == nil then
		heal_efficiency_overeat.playerlist[playername] = {}
		heal_efficiency_overeat.playerlist[playername].heal_boost_increase = heal_efficiency_overeat.settings.health_growth_increase
		heal_efficiency_overeat.playerlist[playername].current_heal_boost = 0
		heal_efficiency_overeat.playerlist[playername].max_heal_boost = heal_efficiency_overeat.settings.max_health_growth
	end
	heal_efficiency_monoid:add_change(player,heal_efficiency_overeat.playerlist[playername].current_heal_boost,"heal_efficiency_overeat:heal_boost")
end)