--file handling
function adjustable_cooldowns.save_to_file()
	local savetable = {}
	savetable.playerlist = adjustable_cooldowns.playerlist
	local savestring = minetest.serialize(savetable)
	local filepath = minetest.get_worldpath().."/adjustable_cooldowns.mt"
	local file = io.open(filepath,'w')
	if file then
		file:write(savestring)
		minetest.log("action","[adjustable_cooldowns] Wrote adjustable_cooldowns data into "..filepath..".")
	else
		minetest.log("error","[adjustable_cooldowns] Failed to write adjustable_cooldowns data into "..filepath..".")
	end
end

minetest.register_on_leaveplayer(function(player)
	adjustable_cooldowns.save_to_file()
end)

minetest.register_on_shutdown(function()
	minetest.log("action","[adjustable_cooldowns] Server shuts down. Rescuing data to adjustable_cooldowns.")
	adjustable_cooldowns.save_to_file()
end)

do --load the file, if any
	local filepath = minetest.get_worldpath().."/adjustable_cooldowns.mt"
	local file = io.open(filepath,'r')
	if file then
		minetest.log("action","[adjustable_cooldowns] adjustable_cooldowns.mt opened")
		local string_to_write = file:read()
		io.close(file)
		if string_to_write ~= nil then
			local savetable = minetest.deserialize(string_to_write)
			adjustable_cooldowns.playerlist = savetable.playerlist
			minetest.log("action","[adjustable_cooldowns] adjustable_cooldowns.mt successfully read")
		end
	end
end