alternate_breathing_methods = {}
alternate_breathing_methods.settings = {}
alternate_breathing_methods.settings.suffication_damage = 1
alternate_breathing_methods.settings.player_default_breathes_water = false
alternate_breathing_methods.remainder = {}
alternate_breathing_methods.functions = {}
alternate_breathing_methods.dtime = 0


--create the monoid
alternate_breathing_methods.monoids = {}
--[[alternate_breathing_methods.monoid = player_monoids.make_monoid(
	combine = function(amphibious_value1,amphibious_value2)
		return amphibious_value1 + amphibious_value2
	end,
	fold = function(tab)
		local res = 0
		for a, value in pairs(tab) do
			res = res + value
		end
		if res < 0 then return 0 end
		if res > 1 then return 1 end
		return res
	end,
	identity = 0
)--]]


--functions
alternate_breathing_methods.functions = {}
function alternate_breathing_methods.functions.add_monoid(group_name,default_adaptation)
	if alternate_breathing_methods.monoids[group_name] ~= nil then
		return false
	end
	alternate_breathing_methods.monoids[group_name] = player_monoids.make_monoid(
		combine = function (amphibious_value1,amphibious_value2)
			return amphibious_value1 + amphibious_value2
		end,
		fold = function (tab)
			local res = 0
			for a, value in pairs(tab) do
				res = res + value
			end
			if res < 0 then return 0 end
			if res > 1 then return 1 end
			return res
		end,
		identity = default_adaptation
	)
	return true
end
function alternate_breathing_methods.functions.add_player_adaptation(player,adaption_number,group_name,string_to_use)
	local player = minetest.get_player_by_name(playername)
	if alternate_breathing_methods.monoids[group_name] == nil then
		minetest.log("error","Tried to call alternate_breathing_methods.functions.add_player_adaptation without a valid addaptation name (group_name)")
		return nil
	end
	if not player then return nil end
	return alternate_breathing_methods.monoids[group_name]:add_change(player,adaption_number,string_to_use)
end
function alternate_breathing_methods.functions.remove_player_adaptation(player,group_name,identifier)
	local player = minetest.get_player_by_name(playername)
	if alternate_breathing_methods.monoids[group_name] == nil then
		minetest.log("error","Tried to call alternate_breathing_methods.functions.remove_player_adaptation without a valid addaptation name (group_name)")
		return
	end
	if not player then return nil end
	alternate_breathing_methods.monoids[group_name]:del_change(player,identifier)
end
function alternate_breathing_methods.functions.get_value(player,group_name)
	local player = minetest.get_player_by_name(playername)
	if alternate_breathing_methods.monoids[group_name] == nil then
		minetest.log("error","Tried to call alternate_breathing_methods.functions.get_value without a valid addaptation name (group_name)")
		return -1
	end
	if not player then return nil end
	return alternate_breathing_methods.monoids[group_name]:value(player)
end
function alternate_breathing_methods.functions.can_breathe(playername,groupname)
	local player = minetest.get_player_by_name(playername)
	if type(playername) ~= "string" or alternate_breathing_methods.playerlist[playername] == nil then
		minetest.log("error","Tried to call alternate_breathing_methods.functions.can_breath_water without a valid playername.")
		return false
	end
	if not player then return nil end
	return alternate_breathing_methods.monoids[group_name]:value(player) >= 0.5
end


--node group override
minetest.register_on_mods_loaded(function()
	local function get_node_group(name, group)
		if not minetest.registered_nodes[name] or not minetest.registered_nodes[name].groups[group] then
			return 0
		end
		return minetest.registered_nodes[name].groups[group]
	end

	for nodename,nodedef in pairs(minetest.registered_nodes) do
		if nodedef ~= nil and nodedef.drowning ~= 0 then
			for breathing_group,monoid in pairs(alternate_breathing_methods.monoids) do
				local group_value = get_node_group(nodename,breathing_group)
				if group_value >= 0 then
					nodedef.drowning = 0
					minetest.register_node(":" .. nodename, nodedef)
					break
				end
			end
		end
	end
end)

--water breathing logic
minetest.register_globalstep(function(dtime)
	alternate_breathing_methods.dtime = alternate_breathing_methods.dtime + dtime
	if alternate_breathing_methods.dtime >= 0.25 then
		alternate_breathing_methods.dtime = alternate_breathing_methods.dtime - 0.25
		local players = minetest.get_connected_players()
		for index,player in pairs(players) do
			local playername = player:get_player_name()
			local collisionbox = player_monoids.collisionbox:value(player)
			local player_pos = player:get_pos()
			local breath_pos = {x = 0.5, y = 1.5, z = 0.5}
			breath_pos.x = breath_pos.x * collisionbox.x + player_pos.x
			breath_pos.y = breath_pos.y * collisionbox.y + player_pos.y
			breath_pos.z = breath_pos.z * collisionbox.z + player_pos.z
			local node = minetest.get_node({x = breath_pos.x,y = breath_pos.y,z = breath_pos.z})
			local def = minetest.registered_nodes[node]
			if def then
				local adaptation = 0.0
				local modified = 0
				for group, value in pairs(def.groups) do
					if value > 0 and alternate_breathing_methods.monoids[group] ~= nil then
						modified = modified + value
						adaptation = adaptation + (alternate_breathing_methods.monoids[group]:value(player)*value)
					end
				end
				if modified <= 0 then
					adaptation = (adaptation / modified) * 2
					adaptation = 2 - adaptation
					alternate_breathing_methods.remainder[playername] = alternate_breathing_methods.remainder[playername] + adaptation
					if adaptation == 0 then alternate_breathing_methods.remainder[playername] = 0 end
					while alternate_breathing_methods.remainder[playername] > 1 do
						local current_breath = player:get_breath()
						if current_breath >= 0 then
							player:set_hp(player:get_hp()-alternate_breathing_methods.settings.suffication_damage,{reason="drowning"})
						else
							player:set_breath(current_breath - 1)
						end
					end
				end
			end
			--minetest.chat_send_player(player:get_player_name(),"drowning tick: "..tostring(player:get_breath()))
		end
	end
end)


--file handling
minetest.register_on_joinplayer(function(player)
	local playername = player:get_player_name()
	if alternate_breathing_methods.remainder[playername] == nil then
		alternate_breathing_methods.remainder[playername] = 0
	end
end)