-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
local tntname = "tnt:tnt"
local tntdef = core.registered_items[tntname]
local old_on_place = tntdef.on_place
local old_on_punch = tntdef.on_punch
local old_on_ignite = tntdef.on_ignite
core.override_item(tntname, {
	on_place = function(itemstack, placer, pointed_thing)
		local name = placer:get_player_name()
		if not core.check_player_privs(name,
				{tnt = true}) then
			core.chat_send_player(name, antigp.tnt_message)
			return nil
		end

		return old_on_place(itemstack, placer, pointed_thing)
	end,
	on_punch = function(pos, node, puncher)
		local name = puncher:get_player_name()
		if not core.check_player_privs(name,
				{tnt = true}) then
			core.chat_send_player(name, antigp.tnt_message)
			return nil
		end

		return old_on_punch(pos, node, puncher)
	end,
	on_ignite = function(pos, igniter)
		local name = igniter:get_player_name()
		if not core.check_player_privs(name,
				{tnt = true}) then
			core.chat_send_player(name, antigp.tnt_message)
			return nil
		end

		return old_on_ignite(pos, igniter)
	end,
})
