-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
local modpath = core.get_modpath(core.get_current_modname())

antigp = { }

antigp.lava_message = core.settings:get("antigp_lava_message") or "Lava usage is currently disabled for you. Please talk to an administrator."
antigp.water_message = core.settings:get("antigp_water_message") or "Water usage is currently disabled for you. Please talk to an administrator."
antigp.tnt_message = core.settings:get("antigp_tnt_message") or "TNT usage is currently disabled for you. Please talk to an administrator."

core.register_privilege("lava", {description = "Lava use priv", give_to_singleplayer=false})
core.register_privilege("water", {description = "Water use priv", give_to_singleplayer=false})
core.register_privilege("tnt", {description = "TNT use priv", give_to_singleplayer=false})

antigp.lava_sources = {}
antigp.water_sources = {}

local lava_sources = antigp.lava_sources
local water_sources = antigp.water_sources

if core.get_modpath("default") then
	lava_sources[#lava_sources + 1] = "default:lava_source"
	water_sources[#water_sources + 1] = "default:water_source"
	water_sources[#water_sources + 1] = "default:river_water_source"
end
if core.get_modpath("everness") then
	if core.registered_items["everness:lava_source"] then
		lava_sources[#lava_sources + 1] = "everness:lava_source"
	end
	water_sources[#water_sources + 1] = "everness:mineral_water_source"
end

if core.get_modpath("bucket") and core.get_modpath("default") then
	local old_on_use = core.registered_items["bucket:bucket_empty"].on_use
	core.override_item("bucket:bucket_empty", {
		on_use = function(itemstack, user, pointed_thing)
			-- Must be pointing to node
			if pointed_thing.type ~= "node" then
				return nil
			end
			-- Check if pointing to a liquid source
			local node = core.get_node(pointed_thing.under)
			local liquiddef = bucket.liquids[node.name]
			local item_count = user:get_wielded_item():get_count()
			local player_name = user:get_player_name()

			-- lava check
			for i = 1, #lava_sources do
				if node.name == lava_sources[i] and not core.check_player_privs(player_name, {lava = true}) then
					core.chat_send_player(player_name, antigp.lava_message)
					return nil
				end
			end

			-- water check
			for i = 1, #water_sources do
				if node.name == water_sources[i] and not core.check_player_privs(player_name, {water = true}) then
					core.chat_send_player(player_name, antigp.water_message)
					return nil
				end
			end

			return old_on_use(itemstack, user, pointed_thing)
		end,
	})
end

dofile(modpath .. "/lava.lua")
dofile(modpath .. "/water.lua")
if core.get_modpath("tnt") and core.registered_items["tnt:tnt"] then
	dofile(modpath .. "/tnt.lua")
end

