-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
-- override on_place
local on_place_items = antigp.lava_sources
if core.get_modpath("bucket") and core.get_modpath("default") then
	on_place_items[#on_place_items + 1] = "bucket:bucket_lava"
	if core.get_modpath("everness") and core.registered_items["everness:bucket_lava"] then
		on_place_items[#on_place_items + 1] = "everness:bucket_lava"
	end
end

-- override on_use
local on_use_items = {}

if core.get_modpath("technic") then
	on_place_items[#on_place_items + 1] = "technic:lava_can"
	on_use_items[#on_use_items + 1] = "technic:lava_can"
end

for i = 1, #on_place_items do
	local item = on_place_items[i]
	local old_on_place = core.registered_items[item].on_place
	core.override_item(item, {
		on_place = function(itemstack, placer, pointed_thing)
			local name = placer:get_player_name()
			if core.check_player_privs(name,
					{lava = true}) then
				return old_on_place(itemstack, placer, pointed_thing)
			end
			core.chat_send_player(name, antigp.lava_message)
			return nil
		end,
	})
end

for i = 1, #on_use_items do
	local item = on_use_items[i]
	local old_on_use = core.registered_items[item].on_use
	core.override_item(item, {
		on_use = function(itemstack, user, pointed_thing)
			local name = user:get_player_name()
			if core.check_player_privs(name,
					{lava = true}) then
				return old_on_use(itemstack, user, pointed_thing)
			end
			core.chat_send_player(name, antigp.lava_message)
			return nil
		end
	})
end

