-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
local lava_nodes = antigp.lava_nodes
local water_nodes = antigp.water_nodes

local function make_override_func(old_func)
	return function(itemstack, user, pointed_thing)
		-- Must be pointing to node
		if pointed_thing.type ~= "node" then
			return nil
		end
		-- Check if pointing to a liquid source
		local node = core.get_node(pointed_thing.under)
		local item_count = user:get_wielded_item():get_count()
		local player_name = user:get_player_name()

		-- lava check
		for i = 1, #lava_nodes do
			if node.name == lava_nodes[i] and not core.check_player_privs(player_name, {lava = true}) then
				core.chat_send_player(player_name, antigp.lava_message)
				return nil
			end
		end

		-- water check
		for i = 1, #water_nodes do
			if node.name == water_nodes[i] and not core.check_player_privs(player_name, {water = true}) then
				core.chat_send_player(player_name, antigp.water_message)
				return nil
			end
		end

		return old_func(itemstack, user, pointed_thing)
	end
end

if core.get_modpath("bucket") and core.get_modpath("default") then
	local old_on_use = core.registered_items["bucket:bucket_empty"].on_use
	local func = make_override_func(old_on_use)
	core.override_item("bucket:bucket_empty", {
		on_use = func,
	})
end

if core.get_modpath("mcl_buckets") then
	local old_on_place = core.registered_items["mcl_buckets:bucket_empty"].on_place
	local func_place = make_override_func(old_on_place)
	local old_on_secondary_use = core.registered_items["mcl_buckets:bucket_empty"].on_secondary_use
	local func_use = make_override_func(old_on_secondary_use)
	core.override_item("mcl_buckets:bucket_empty", {
		on_place = func_place,
		on_secondary_use = func_use,
	})
end
