-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
local lava_nodes = antigp.lava_nodes
local water_nodes = antigp.water_nodes

local gameid = core.get_game_info().id
-- setting from Voxelibre (mineclone2)
local use_select_box = minetest.settings:get_bool("mcl_buckets_use_select_box", false)

local raycast = core.raycast
local get_node = core.get_node
local registered_nodes = core.registered_nodes
-- copied from VoxeLibre (mineclone2) mcl_buckets mod
-- Copyright VoxeLibre contributors, GPLv3
local function bucket_get_pointed_thing(user)
	local start = user:get_pos()
	start.y = start.y + user:get_properties().eye_height
	local look_dir = user:get_look_dir()
	local _end = vector.add(start, vector.multiply(look_dir, 5))

	local ray = raycast(start, _end, false, true)
	for pointed_thing in ray do
		local name = get_node(pointed_thing.under).name
		local def = registered_nodes[name]
		if not def or def.drawtype ~= "flowingliquid" then
			return pointed_thing
		end
	end
end
--

local function make_override_func(old_func)
	return function(itemstack, user, pointed_thing)
		if user then
			-- Using `gameid` isn't good for forks of VoxeLibre, but I don't know
			-- how else to do this.
			if gameid == "mineclone2" and not use_select_box then
				pointed_thing = bucket_get_pointed_thing(user)
			end

			-- Must be pointing to node
			if not pointed_thing or pointed_thing.type ~= "node" then
				return old_func(itemstack, user, pointed_thing)
			end
			-- Check if pointing to a liquid source
			local node = core.get_node(pointed_thing.under)
			local item_count = user:get_wielded_item():get_count()
			local player_name = user:get_player_name()

			-- lava check
			for i = 1, #lava_nodes do
				if node.name == lava_nodes[i] and not core.check_player_privs(player_name, {lava = true}) then
					core.chat_send_player(player_name, antigp.lava_message)
					return nil
				end
			end

			-- water check
			for i = 1, #water_nodes do
				if node.name == water_nodes[i] and not core.check_player_privs(player_name, {water = true}) then
					core.chat_send_player(player_name, antigp.water_message)
					return nil
				end
			end
		end

		return old_func(itemstack, user, pointed_thing)
	end
end

if core.get_modpath("bucket") and core.get_modpath("default") then
	local old_on_use = core.registered_items["bucket:bucket_empty"].on_use
	local func = make_override_func(old_on_use)
	core.override_item("bucket:bucket_empty", {
		on_use = func,
	})
end

if core.get_modpath("mcl_buckets") then
	local old_on_place = core.registered_items["mcl_buckets:bucket_empty"].on_place
	local func_place = make_override_func(old_on_place)
	local old_on_secondary_use = core.registered_items["mcl_buckets:bucket_empty"].on_secondary_use
	local func_use = make_override_func(old_on_secondary_use)
	core.override_item("mcl_buckets:bucket_empty", {
		on_place = func_place,
		on_secondary_use = func_use,
	})
end
