-- The MIT License (MIT) Copyright © 2025  Olivia May and contributors
antigp.tnt_message = core.settings:get("antigp_tnt_message") or "TNT usage is currently disabled for you. Please talk to an administrator."

core.register_privilege("tnt", {description = "TNT use priv", give_to_singleplayer=false})

local function check_privs(player, old_func, ...)
	if player then
		local name = player:get_player_name()
		if not core.check_player_privs(name, {tnt = true}) then
			core.chat_send_player(name, antigp.tnt_message)
			return nil
		end
	end

	return old_func(...)
end

if core.get_modpath("tnt") and core.registered_items["tnt:tnt"] then

local tntname = "tnt:tnt"
local tntdef = core.registered_items[tntname]
local old_on_place = tntdef.on_place
local old_on_punch = tntdef.on_punch
local old_on_ignite = tntdef.on_ignite
core.override_item(tntname, {
	on_place = function(itemstack, placer, pointed_thing)
		check_privs(placer, old_on_place, itemstack, placer, pointed_thing)
	end,
	on_punch = function(pos, node, puncher)
		check_privs(puncher, old_on_punch, pos, node, puncher)
	end,
	on_ignite = function(pos, igniter)
		check_privs(igniter, old_on_ignite, pos, igniter)
	end,
})

end

if core.get_modpath("mcl_tnt") then
	local tntname = "mcl_tnt:tnt"
	local tntdef = core.registered_items[tntname]
	local old_on_place = tntdef.on_place
	local old__on_ignite = tntdef._on_ignite
	core.override_item(tntname, {
		on_place = function(itemstack, placer, pointed_thing)
			check_privs(placer, old_on_place, itemstack, placer, pointed_thing)
		end,
		_on_ignite = function(user, pointed_thing)
			check_privs(user, old__on_ignite, user, pointed_thing)
		end,
	})
end
